function [LTxt] = profile(x,t,sP0,mu,Ddot,D0,LT_SS)
%S18eq4 Eqn. 4 from Sohbati et al., 2018, scaled by LT_SS
%   x (mm)
%   t (ka)
%   sP0 (ka^-1)
%   mu (mm^-1)
%   Ddot (Gy/ka)
%   D0 (Gy)
%   LT_SS (Ln/Tn at field saturation or 'steady state')

Ex=sP0*exp(-mu*x);%Eq. 2
F=Ddot/D0;%Eq. 3

LTxt=LT_SS*(Ex.*exp(-t.*(Ex + F)) + F)./(Ex + F);%Eq. 4

end