%% load Ln/Tn data
%% KAY-110; IR50
IR50_KAY110=[0.2363	0.1141
0.2710	0.0694
0.5187	0.4296
1.0460	1.0165
1.2587	0.7664
3.1913	1.0833
3.7380	0.6357
3.0123	0.7878
3.8820	1.5596
2.9977	0.4359
3.7553	0.2155];
%% KAY-110; pIRIR225
pIR225_KAY110=[1.8380	0.9013
2.7530	0.7441
3.3330	1.4621
4.8187	1.7910
5.7783	0.6635
6.7830	0.4950
6.1283	2.4222
5.1233	1.6755
5.9737	1.3939
5.2783	2.2958
5.5553	1.4049];
%% 19-KP-H1; IR50
IR50_H1=[2.1330	0.0598
2.5140	0.1961
2.3060	0.1518
2.3430	0.1377
2.5117	0.3937
2.4553	0.1452
2.3880	0.2513
2.4760	0.2932
2.4240	0.1591
2.5783	0.2819
2.6187	0.1902
2.5937	0.1058
2.6327	0.1075
2.6720	0.1266
2.6260	0.2087
2.6193	0.0815
2.8400	0.7977
2.5403	0.2080
2.5490	0.1140
2.8647	0.0697
2.5320	0.1551];
%% 19-KP-H1; pIRIR225
pIR225_H1=[4.0493	0.1550
4.3703	0.9031
4.7967	1.3586
4.1140	0.2016
4.0050	0.2122
4.1520	0.3513
4.6570	0.2024
4.2593	0.0927
4.1710	0.4770
5.1237	0.7490
4.5117	0.4369
4.9513	0.4105
5.3873	1.4738
5.0287	0.7488
5.0690	0.5659
5.3920	1.1209
5.4793	0.2879
5.1687	0.5013
5.5133	1.0104
4.5483	0.1914
5.0983	0.1046];
%% load depths
mean_depth_mm_KAY110=[0.95
2.88
4.56
6.19
7.82
9.65
11.68
13.51
15.19
16.97
18.65];

mean_depth_mm_H1=[1.575
4.23
5.81
7.34
8.97
11.17
13.32
15.02
16.82
18.47
20.07
22.22
24.27
25.72
27.42
29.07
30.77
32.47
34.02
35.62
39.07];
%% fit known age profile (KAY-110) to determine mu and sP0

%known luminescence characteristics
Ddot=4.6;%Gy/ka
D0_IR50=743;%Gy
D0_pIR225=mean([384,402]);

%known age
t_KAY110=1467/(365.25*1e3);%ka; Jan 7, 2016 to Jan 13, 2020

%initial guesses for mu, sP0, LT_SS
mu_array=0.01:0.01:2;%mm^-1
sP0_array=10:5:3500;%ka^-1
LT_SS_KAY50_0=3.5;
LT_SS_KAY225_0=5.6;

SOSmat_50=zeros(length(mu_array),length(sP0_array));
SOSmat_225=zeros(length(mu_array),length(sP0_array));
h=waitbar(0,'Solving for mu, sP0...');
for i=1:length(mu_array)
    mu_i=mu_array(i);
    waitbar(i/length(mu_array))
    for j=1:length(sP0_array)
        sP0_i=sP0_array(j);
        %LNTN fits for misfits
        %IR50
        LTxt_for_misfit=profile(mean_depth_mm_KAY110,t_KAY110,sP0_i,mu_i,Ddot,D0_IR50,LT_SS_KAY50_0);
        SOS_ij_50=sum((LTxt_for_misfit - IR50_KAY110(:,1)).^2./IR50_KAY110(:,2).^2);
        SOSmat_50(i,j)=SOS_ij_50;
        %pIR225
        LTxt_for_misfit=profile(mean_depth_mm_KAY110,t_KAY110,sP0_i,mu_i,Ddot,D0_pIR225,LT_SS_KAY225_0);
        SOS_ij_225=sum((LTxt_for_misfit - pIR225_KAY110(:,1)).^2./pIR225_KAY110(:,2).^2);
        SOSmat_225(i,j)=SOS_ij_225;
    end
end
close(h)
%% plot error as fxn of mu and sP0
figure
subplot(2,1,1)
[muMat,sP0mat]=meshgrid(mu_array,sP0_array);
surf(muMat,sP0mat,[SOSmat_50]','EdgeColor','none')
xlabel('attenuation coefficient (mm^{-1})')
ylabel('surficial detrapping probability (ka^{-1})')
c = colorbar;
c.Label.String = 'Weighted SSE';
view(2)
caxis([0 15])
hold on
plot3(0.32,1550,1e4,'k+')%IR50

subplot(2,1,2)
[muMat,sP0mat]=meshgrid(mu_array,sP0_array);
surf(muMat,sP0mat,[SOSmat_225]','EdgeColor','none')
xlabel('attenuation coefficient (mm^{-1})')
ylabel('surficial detrapping probability (ka^{-1})')
c = colorbar;
c.Label.String = 'Weighted SSE';
view(2)
caxis([0 15])
hold on
plot3(0.54,650,1e4,'+k')%pIRIR
%% plot profiles for KAY-110

% these values from above error plots
%IR50
mu50_final=0.32;
sP050_final=1550;

%IR225
mu225_final=0.54;
sP0225_final=650;

%LNTN fits for plotting
plottingDepths_KAY=linspace(min(mean_depth_mm_KAY110),max(mean_depth_mm_KAY110),200);
LTxt50_plot=profile(plottingDepths_KAY,t_KAY110,sP050_final,mu50_final,Ddot,D0_IR50,LT_SS_KAY50_0);
LTxt225_plot=profile(plottingDepths_KAY,t_KAY110,sP0225_final,mu225_final,Ddot,D0_pIR225,LT_SS_KAY225_0);
    
figure
errorbar(mean_depth_mm_KAY110,IR50_KAY110(:,1),IR50_KAY110(:,2),'bo')
hold on
errorbar(mean_depth_mm_KAY110,pIR225_KAY110(:,1),pIR225_KAY110(:,2),'rs')
plot(plottingDepths_KAY,LTxt50_plot,'b')
plot(plottingDepths_KAY,LTxt225_plot,'r')
hold off
xlabel('depth (mm)')
ylabel('L_N/T_N')
%% plot profiles for H1 based on various bleach durations

figure
for t_H1=[1,10,50,100]%ka
    hold on
    
    LT_SS_H150_0=2.70;
    LT_SS_H1225_0=5.03;

    %LNTN fits for plotting
    plottingDepths_H1=linspace(min(mean_depth_mm_H1),max(mean_depth_mm_H1),200);
    LTxt50_plot=profile(plottingDepths_H1,t_H1,sP050_final,mu50_final,Ddot,D0_IR50,LT_SS_H150_0);
    LTxt225_plot=profile(plottingDepths_H1,t_H1,sP0225_final,mu225_final,Ddot,D0_pIR225,LT_SS_H1225_0);

    errorbar(mean_depth_mm_H1,IR50_H1(:,1),IR50_H1(:,2),'bo')
    hold on
    errorbar(mean_depth_mm_H1,pIR225_H1(:,1),pIR225_H1(:,2),'rs')
    plot(plottingDepths_H1,LTxt50_plot,'b')
    plot(plottingDepths_H1,LTxt225_plot,'r')
    xlabel('depth (mm)')
    ylabel('L_N/T_N')
%    hold off
end