%% Populate dosimetry measurements

% Attenuation factors of Sohbati et al. (2015)
gammaAF=0.02;
betaAF=1.9;

% Dose rate components common to all samples, Gy/ka and error
cosmic=[0.04,0.04];
internalDryAlpha=[0,0];
internalDryBeta=[2.888,0.879];
internal=[2.888,0.879];

% External dose rate components, row per sample: H1@6-7cm,
%   H1@47-48, H4@5.7-7.5, H4@57-58, H4@108-109
wcAlpha=[0.027,0.011
    0.062,0.027
    0.008,0.003
    0.017,0.007
    0.004,0.001];% wc is 'water corrected'

wcBeta=[1.06,0.013
    1.231,0.015
    0.653,0.008
    0.827,0.01
    0.438,0.005];

wcGamma=[0.821,0.029
    1.381,0.055
    0.371,0.015
    0.572,0.021
    0.232,0.01];

external=[1.943,0.035
    2.715,0.063
    1.072,0.018
    1.455,0.025
    0.713,0.012];

doseRate=[4.831,0.880
    5.603,0.882
    3.96,0.880
    4.343,0.880
    3.602,0.880];

%% Load arrays of sliced depths (mm). These are in pairs: 1&2 are top and bottom
%    of first rock piece, 3&4 are top and bottom of second piece...
h1=[0;3.15000000000000;3.53000000000000;4.93000000000000;5.31000000000000;6.31000000000000;6.69000000000000;7.99000000000000;8.37000000000000;9.57000000000000;9.87000000000000;12.4700000000000;12.7700000000000;13.8700000000000;14.1700000000000;15.8700000000000;16.1700000000000;17.4700000000000;17.7700000000000;19.1700000000000;19.4700000000000;20.6700000000000;20.9700000000000;23.4700000000000;23.7700000000000;24.7700000000000;25.0700000000000;26.3700000000000;26.6700000000000;28.1700000000000;28.4700000000000;29.6700000000000;29.9700000000000;31.5700000000000;31.8700000000000;33.0700000000000;33.3700000000000;34.6700000000000;34.9700000000000;36.2700000000000;36.5700000000000;41.5700000000000];
h4=[0;1.20000000000000;1.58000000000000;2.98000000000000;3.36000000000000;4.56000000000000;4.94000000000000;6.24000000000000;6.62000000000000;8.02000000000000;8.40000000000000;9.60000000000000;9.98000000000000;11.1800000000000;11.5600000000000;13.1600000000000;13.5400000000000;14.0400000000000;14.4200000000000;16.0200000000000;16.4000000000000;18.7000000000000;19.0800000000000;26.8800000000000;27.2600000000000;46.5800000000000];
kay=[0;1.90000000000000;2.28000000000000;3.48000000000000;3.86000000000000;5.26000000000000;5.64000000000000;6.74000000000000;7.12000000000000;8.52000000000000;8.90000000000000;10.4000000000000;10.7800000000000;12.5800000000000;12.9600000000000;14.0600000000000;14.4400000000000;15.9400000000000;16.3200000000000;17.6200000000000;18;19.3000000000000;19.6800000000000;27.2800000000000];

figure

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%   H1
%
%
%% Calculate depth arrays for dose rate components
depthsSampled=h1;
depthsSpaced=linspace(0,max(depthsSampled),500);

internalArray=internal(1,1)*ones(size(depthsSpaced));
cosmicArray=cosmic(1,1)*ones(size(depthsSpaced));

externalAlphaArray=wcAlpha(1,1)*ones(size(depthsSpaced));
externalBetaArray=wcBeta(1,1)*(1-0.5*exp(-depthsSpaced*betaAF));
externalGammaArray=wcGamma(1,1)*(1-0.5*exp(-depthsSpaced*gammaAF));

totalArray=internalArray+cosmicArray+externalAlphaArray+externalBetaArray+externalGammaArray;

%% plot dose rate arrays
subplot(1,2,1)
hold on
plot(internalArray,depthsSpaced)
plot(cosmicArray,depthsSpaced)
plot(externalAlphaArray,depthsSpaced)
plot(externalBetaArray,depthsSpaced)
plot(externalGammaArray,depthsSpaced)
plot(totalArray,depthsSpaced)
%set(gca,'xscale','log')
%set(gca,'yscale','log')
ylabel('Depth (mm)')
xlabel('Dose rate (Gy/ka)')
xlim([-0.5 5])

%% plot sampled depths as rectangles
for i=1:2:length(depthsSampled)-1
    rectangle('Position',[-0.25 depthsSampled(i) 5.25 depthsSampled(i+1)-depthsSampled(i)],'EdgeColor',[0.8,0.8,0.8])
end

%% tweak plot appearance
xlim([-0.5 5.5])
ylim([-5 50])
set(gca,'YDir','reverse')

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%   H4
%
%
%% Calculate depth arrays for dose rate components
depthsSampled=h4;
depthsSpaced=linspace(0,max(depthsSampled),500);

internalArray=internal(1,1)*ones(size(depthsSpaced));
cosmicArray=cosmic(1,1)*ones(size(depthsSpaced));

externalAlphaArray=wcAlpha(3,1)*ones(size(depthsSpaced));
externalBetaArray=wcBeta(3,1)*(1-0.5*exp(-depthsSpaced*betaAF));
externalGammaArray=wcGamma(3,1)*(1-0.5*exp(-depthsSpaced*gammaAF));

totalArray=internalArray+cosmicArray+externalAlphaArray+externalBetaArray+externalGammaArray;

%% plot dose rate arrays
subplot(1,2,2)
hold on
plot(internalArray,depthsSpaced)
plot(cosmicArray,depthsSpaced)
plot(externalAlphaArray,depthsSpaced)
plot(externalBetaArray,depthsSpaced)
plot(externalGammaArray,depthsSpaced)
plot(totalArray,depthsSpaced)
%set(gca,'xscale','log')
%set(gca,'yscale','log')
ylabel('Depth (mm)')
xlabel('Dose rate (Gy/ka)')
xlim([-0.5 5])

%% plot sampled depths as rectangles
for i=1:2:length(depthsSampled)-1
    rectangle('Position',[-0.25 depthsSampled(i) 5.25 depthsSampled(i+1)-depthsSampled(i)],'EdgeColor',[0.8,0.8,0.8])
end

%% tweak plot appearance
xlim([-0.5 5.5])
ylim([-5 50])
set(gca,'YDir','reverse')