function out = objective_lognormal(X,binmids,counts)

% generates lognormal distribution and compares to histogram

mulog = X(1);
sigmalog = X(2);

yy = (1./(binmids.*sigmalog.*sqrt(2.*pi))).*exp(-(log(binmids)-mulog).^2./(2.*sigmalog.^2));

yy = yy.*X(3)./max(yy);


if nargin == 3
    % In use as objective function, return misfit
    out = sum((yy - counts).^2);
elseif nargin == 2
    % Just evaluate at given points
    out = yy;
end
    