function out = objective_Zmass(X,fitx,fity,rhoice)


% This is the objective function for fitting a relationship between ice
% thickness and mass depth. Asserts that the form of the function is
%
% y = x*rho_ice - a * (1 - exp(-x./b))
%
% where a and b are the parameters we need to fit. 


predy = fitx.*rhoice - X(1).*(1 - exp(-fitx./X(2)));
out = sum((fity - predy).^2);

