function init_Be10_data()

% this just loads Be-10 data into a variable structure and saves it. 

% Paste in from Keir's spreadsheet. These are mid-depth, N10 (atoms/g),
% delN10 (atoms/g).

dH1 = [12	6575	662
22	6598	646
32	6947	795
42	4195	894
53	4064	758
63	4914	789
73	3704	747
83	3340	1040
91.5	2683	965
109.5	2228	887
109.5	2737	680];

dH4 = [12.25	3886	580
22	3353	809
32	2782	525
42	3475	682
52	2171	677
63	3655	804
73	2236	988
83	2419	680
93	2866	829
103	2224	1155
114	2459	677
123.5	3022	505
132.5	1389	677];

dH5 = [5	4631	931
15	4746	1096
25	4433	778
35	3845	515
45	3846	486
56	2531	740
66	2166	1033
76	3616	749
86	2527	773
96	3152	784
106	2655	640
116	2331	567
124	3480	751];

dH6 = [3.5	18550	2427
3.5	17627	1870];

% Sort into organized form
d10.H1.z = dH1(:,1); d10.H1.N = dH1(:,2); d10.H1.dN = dH1(:,3);
d10.H4.z = dH4(:,1); d10.H4.N = dH4(:,2); d10.H4.dN = dH4(:,3);
d10.H5.z = dH5(:,1); d10.H5.N = dH5(:,2); d10.H5.dN = dH5(:,3);
d10.H6.z = dH6(:,1); d10.H6.N = dH6(:,2); d10.H6.dN = dH6(:,3);

% Also place in confidence bounds type form to match C-14 data

for a = 1:length(d10.H1.z)
    d10.H1.Natomsg_bounds(a,:) = [-2 -1 0 1 2].*d10.H1.dN(a) + d10.H1.N(a);
end

for a = 1:length(d10.H4.z)
    d10.H4.Natomsg_bounds(a,:) = [-2 -1 0 1 2].*d10.H4.dN(a) + d10.H4.N(a);
end

for a = 1:length(d10.H5.z)
    d10.H5.Natomsg_bounds(a,:) = [-2 -1 0 1 2].*d10.H5.dN(a) + d10.H5.N(a);
end

save data_Be10 d10
