function init_Al26_data()

% this just loads Al-26 data for H1 into a variable structure and saves it. 

% Paste in from supplement spreadsheet. 

% sample names

sample_names = {'H1-17-27'
'H1-48-58'
'H1-105-114' % note fixed
'H1-27-37'
'H1-58-68'
'H1-78-88'
'H1-7-17'
'H1-88-95'
'H1-68-78'
'H1-105-114'
'H1-37-47'};

% Process sample names to get mid-depths

for a = 1:length(sample_names)
    this_name = sample_names{a};
    split_name = split(this_name,'-');
    this_td = str2num(split_name{2});
    this_bd = str2num(split_name{3});
    middepths(a) = (this_td + this_bd)./2;
end

% Al-26 concentrations
dH1 = [4.316E+04	2.860E+03
2.761E+04	2.944E+03
2.237E+04	2.960E+03
3.851E+04	3.441E+03
2.716E+04	4.147E+03
2.813E+04	3.880E+03
4.385E+04	6.361E+03
2.527E+04	3.282E+03
2.174E+04	2.810E+03
1.617E+04	3.453E+03
3.681E+04	5.260E+03];


% Sort into organized form
d26.H1.z = middepths'; d26.H1.N = dH1(:,1); d26.H1.dN = dH1(:,2);

% Also place in confidence bounds type form to match C-14 data

for a = 1:length(d26.H1.z)
    d26.H1.Natomsg_bounds(a,:) = [-2 -1 0 1 2].*d26.H1.dN(a) + d26.H1.N(a);
end



save data_Al26 d26
