function out = generate_random_Et(surface_elv_now,site_elv_now,dirty_ice_thickness)

% This is supposed to randomly generate age-elevation histories that meet
% certain criteria.
%
% Greg Balco
% Berkeley Geochronology Center
% February, 2022
%
% Accompanies a paper entitled 'REVERSIBLE ICE SHEET THINNING IN THE
% AMUNDSEN SEA EMBAYMENT DURING THE LATE HOLOCENE,' by Balco, Brown,
% Nichols, Venturelli, and others. 
%
% This code is provided solely for review of the accompanying paper. It
% is not licensed for other use or distribution. 

% One. Must start at 350 m, 35000 years

tmax = 35000; Emax = 350;

% Two. Must start dropping between 9000 and 6000 years ago

E4 = 350;

start_min = 6000;
start_max = 9000;

t4 = rand(1).*(start_max - start_min) + start_min;

% Three. Can have two nodes between t4 and 0. 

tempts = sort(rand(1,2).*t4);

thin_min_E = site_elv_now + dirty_ice_thickness;
thin_max_E = 100; % ad hoc

tempEs = rand(1,2).*(thin_max_E - thin_min_E) + thin_min_E;

out.times = [0 tempts t4 tmax];
out.surface_elvs = [surface_elv_now tempEs E4 Emax];
