function out = PofZofT(t,times,elvs,depths,P,nuclide)

% This is the objective function that generates P at a particular time for
% use in the MATLAB numerical integration routine.
%
% Greg Balco
% Berkeley Geochronology Center
% Feb, 2022
% 
% Accompanies a paper entitled 'REVERSIBLE ICE SHEET THINNING IN THE
% AMUNDSEN SEA EMBAYMENT DURING THE LATE HOLOCENE,' by Balco, Brown,
% Nichols, Venturelli, and others. 
%
% This code is provided solely for review of the accompanying paper. It
% is not licensed for other use or distribution. 

these_elvs = interp1(times,elvs,t);
these_zs = interp1(times,depths,t);

out = KPP(these_elvs,these_zs,nuclide,P);