tsize = 10; % template radius
ssize = 40; % search radius

I1 = imread('T22WEB_20200730T151921_B04_clip.jp2');
I2 = imread('T22WEB_20200720T151911_B04_clip.jp2');
R = [0 -10; +10 0; 546525 7690135]; % geo-reference was lost, when images where transformed to jp2
[xI,yI] = pixcenters(R, size(I1));

I1 = mat2gray(double(I1),[0 15000]); % rescale imagery
I2 = mat2gray(double(I2),[0 15000]);

% figure(); 
% imagesc(xI,yI,I1);
% title('Sentinel-2 scene of Jakobshavn Isbr{\ae}', 'Interpreter', 'latex');
% axis equal; colormap(gray); axis xy; axis tight;

I1 = highpassIm(I1); % apply high-pass filter in frequency domain
I2 = highpassIm(I2);

Ji = fliplr([1096; 1580; 1750]); 
Ii = fliplr([2428; 2448; 725]); % use coordinates as in the manuscript
% Ji = [3327]; Ii = [2087]; 

[ijResult,pcfStack,tempSt,searchSt] = patternMatchExample(I1,I2,[Ii Ji],tsize,ssize,'simple');

%% plot figures as in the manuscript
d = 5; % radius
for k = 1:length(Ji)
    
    figure(); 
    [Xi,Yi] = pix2map(R,[(Ii(k)-ssize):(Ii(k)+ssize)], [(Ji(k)-ssize):(Ji(k)+ssize)]);
    % plot search space
    subplot(2,2,1); imagesc(Xi,Yi, searchSt(:,:,k)); 
    axis equal; axis tight; hold on; axis xy; ax = axis;
    title('search window at time - t1');
    set(gca, 'XtickLabel', num2str(get(gca,'Xtick'),'%5.0f\n'));
    set(gca, 'YtickLabel', num2str(get(gca,'Ytick'),'%5.0f\n'));

    % plot zoom in of point correlation function   
    topI = [ijResult(k,1)-d:ijResult(k,1)+d]+(ssize-tsize)+0;
    topJ = [ijResult(k,2)-d:ijResult(k,2)+d]+(ssize-tsize)+0;
    pcfSlice = pcfStack(:,:,k);
    [Xi,Yi] = pix2map(R,[(Ii(k)+ijResult(k,1)-d):(Ii(k)+ijResult(k,1)+d)], ...
        [(Ji(k)+ijResult(k,2)-d):(Ji(k)+ijResult(k,2)+d)]);
    subplot(2,2,2); surf(Xi,Yi,pcfSlice(topI,topJ)); 
    axis xy; view(26,70); title('zoom and 3D of point correlation')
    set(gca, 'XtickLabel', num2str(get(gca,'Xtick'),'%5.0f\n'));
    set(gca, 'YtickLabel', num2str(get(gca,'Ytick'),'%5.0f\n'));

    % plot template window     
    [Xi,Yi] = pix2map(R,[(Ii(k)-tsize):(Ii(k)+tsize)], ...
        [(Ji(k)-tsize):(Ji(k)+tsize)]);
    subplot(2,2,3); imagesc(Xi,Yi,tempSt(:,:,k)); axis equal; axis tight; axis xy;
    axis(ax); title('template window at time - t2');
    set(gca, 'XtickLabel', num2str(get(gca,'Xtick'),'%5.0f\n'));
    set(gca, 'YtickLabel', num2str(get(gca,'Ytick'),'%5.0f\n'));
    
    % plot correlation image    
    [Xi,Yi] = pix2map(R,[(Ii(k)-(ssize-tsize)):(Ii(k)+(ssize-tsize))], ...
        [(Ji(k)-(ssize-tsize)):(Ji(k)+(ssize-tsize))]);
    subplot(2,2,4); imagesc(Xi,Yi,pcfStack(:,:,k)); axis equal; axis tight; axis xy;
    axis(ax); title('correlation scores');
    set(gca, 'XtickLabel', num2str(get(gca,'Xtick'),'%5.0f\n'));
    set(gca, 'YtickLabel', num2str(get(gca,'Ytick'),'%5.0f\n'));
    colormap(gray)
end

%%
d = 5;
for k = 1:length(Ji)
    %% create gaussians to compare
    iP = ijResult(k,1)+ijResult(k,3); % peak location
    jP = ijResult(k,2)+ijResult(k,4); % peak location
    iS = ijResult(k,8); % peak dispersion
    jS = ijResult(k,7); % peak dispersion
    rho = ijResult(k,9);
    fac = ijResult(k,10); % normalization factor
    
    [Igrd,Jgrd] = ndgrid([round(iP)-d:round(iP)+d], ...
        [round(jP)-d:round(jP)+d]);
    
    A = 1./(2.*pi().*sqrt(iS).*sqrt(jS).*sqrt(1-rho.^2));
    G = A.* ...
        exp( -(1./(2*(1-rho^2))).* ...
        (...
        ( (Igrd-iP).^2 ./iS) ...
        -( ( 2.*rho.*(Igrd-iP).*(Jgrd-jP))./ (sqrt(iS)*sqrt(jS)) ) ...
        +( (Jgrd-jP).^2 ./jS) ...
        ));
    G = fac.*G;    
    
    pcfSlice = pcfStack(:,:,k);
    
    Igrd = Igrd+(ssize-tsize)+0;
    Jgrd = Jgrd+(ssize-tsize)+0;
    [Xi,Yi] = pix2map(R, Igrd,Jgrd);
    Pidx = sub2ind(size(pcfSlice), Igrd,Jgrd);
    P = pcfSlice(Pidx);
    
    figure;
    subplot(1,2,1); imagesc(Xi(1,:),Yi(:,1)',G); axis equal; axis tight; 
    title('estimated Gaussian');
    set(gca, 'XtickLabel', num2str(get(gca,'Xtick'),'%5.0f\n'));
    set(gca, 'YtickLabel', num2str(get(gca,'Ytick'),'%5.0f\n'));
    colormap(gray)
    subplot(1,2,2); imagesc(Xi(1,:),Yi(:,1)',P); axis equal; axis tight;
    title('raw correlation function');
    set(gca, 'XtickLabel', num2str(get(gca,'Xtick'),'%5.0f\n'));
    set(gca, 'YtickLabel', num2str(get(gca,'Ytick'),'%5.0f\n'));
    colormap(gray)
end

