function [Inew] = highpassIm(I,R)
% HIGHPASSIM high pass image of an image
% 
% B. Altena - UiO & UU

if nargin == 1, R = 10; end

[m,n,~] = size(I);
I = perdecomp(double(I));

A = fft2(I);

% Gaussian Filter Response Calculation
x = 0:n-1; y = 0:m-1;
[X,Y] = meshgrid(x,y);
Cx = 0.5.*n; Cy = 0.5.*m;
Hi = fftshift(1 - exp(-((X-Cx).^2+(Y-Cy).^2)./(2*R).^2));

Inew = mat2gray(real(ifft2(A.*Hi)));
end

