function [ qx2,qy2,rho,hess,normFac] = estGauss( pcf, ic, jc, di, dj, est)
%ESTIMATEGAUSSIAN Estimates a gaussian
%
% B. Altena - UiO & IMAU
if nargin<6
    est = 'distance_weighted';
end

pcf = pcf - mean(pcf(:)); % a healthy correltation function has zero mean
[m,n] = size(pcf);

% neighborhood distance, used for the estimation
if min([ic; jc])<=2 || max([ic; jc])>(min([m n])-2)
    d = 1; 
else
    d = 2;
end

idxI = repmat([ic-d:ic+d],2*d+1,1);
idxJ = repmat([jc-d:jc+d]',1,2*d+1);
Zsub = pcf([ic-d:ic+d],[jc-d:jc+d]);
zsub = Zsub;

noiselevel = 0.05;
OUT = Zsub<0; IN = not(OUT);
Zsub(OUT) = noiselevel;
normFac = sum(Zsub(:));
Zsub = Zsub./normFac; % normalize to probability density function

if rank([idxI(OUT) idxJ(OUT) idxI(OUT).*idxJ(OUT)]) < 3
    % the system of equations is ill-posed because to many points are
    % below zero, which is not possible for gaussian estimation.
    % Therefore, the correlation surface is lifted. This does influence
    % the quality of the variance estimation, but better then nothing...
    y = log(Zsub(:)-min(Zsub(:))+1e-2);
    idxI = idxI(:); idxJ = idxJ(:);
else
    % exclude negative values
    % lnTop = log(Zsub(1+d,1+d));
    % OUT(1+d,1+d) = false; % remove top
    idxI = idxI(:); idxJ = idxJ(:); Zsub = Zsub(:);
    % idxI = idxI(IN); idxJ = idxJ(IN); Zsub = Zsub(IN);
    y = log(Zsub(:)); %  - lnTop;
end

A = [(idxI-(ic+di)).^2 ...                  % a
    2.*(idxI-(ic+di)).*(idxJ-(jc+dj)) ...   % b
    (idxJ-(jc+dj)).^2 ...                   % c
    ones(numel(y),1)];                      % amp

%% (weighted) least squares

switch est
    case 'distance_weighted'
        W = (d^2 - sqrt(sum(A(:,[1 3]),2)))./d^2; % distance from top
        hess = lscov(A,y,W);
    case 'weighted'

        noise = log(max(Zsub+noiselevel,1e-10)) - ...
            log(max(Zsub-noiselevel,1e-20));
        wght = (1./noise);
        hess = (A.*(wght*ones(1,4)))\(y.*wght);
    case 'general'
        % f(x,y) = A e^(- (a(x-x0)^2 + b 2(x-x0*y-y0)+ c(y-y0)^2 ))   
        hess = (A)\y;                              % n = [a; b; c]
end
%% include results in output
rho = (.5.*hess(2))./(sqrt(hess(1)*hess(3)));
qx2 = 1./(-2*(1 - rho.^2).*hess(1));
qy2 = 1./(-2*(1 - rho.^2).*hess(3));

%%
if qx2<0 || qy2<0
    qx2 = abs(qx2); qy2 = abs(qy2); rho = 1./rho;
end

%%
if ~isreal(rho) || ~isreal(qy2) || ~isreal(qx2) %% || ...
        % hess(1)<= 0 || hess(3)<= 0 || rho > 1           
    % the top of the peak can be wrongly estimated 
    rho = NaN; 
    qy2 = NaN; 
    qx2 = NaN;
end

end

