function fout = parallel_stability_plane_v2(fin,V_p_0)
%fout = parallel_stability_plane(fin,V_p_0)
%Uses the output of parallel_bifucration_plane_v2 and computes dispersion
%relations for prescribed storage capacity V_p_0
%
%Input arguments
%   fin:        a structure produced as fout by parallel_bifurcation_plane 
%               with fields
%       S_R:    Matrix of steady conduit sizes for R-conduits
%       S_K:    Matrix of steady conduit sizes for K-conduits
%       N:      Matrix of steady effective pressures
%       type1:  String defining the first parameter type varied by
%               parallel_bifurcation_plane_v2
%               Choices are  'uh', 'Q_tot', 'L', 'n_c'
%               and 'V_p'. The value of the parameter is however
%               overwritten by parallel_stability_plane_v2 if type1 is
%               'V_p'
%       type1:  String defining the second parameter type varied by
%               parallel_bifurcation_plane_v2, same choices and caveat as
%               for type1
%       l1:     vector of parameter values used for parameter 1
%       l2:     vector of parameter values used for parameter 2
%       parameters: Same parameter structure as used in
%               parallel_bifuration_plane_v2
%   V_p_0:      Storage capacity for which dispersion relation is to be
%               computed
%Output argument
%   fout:       a structure containing all the information in fin, but with
%               a new field (or overwritten existing field) eig_Vp,
%               corresponding to the eigenvalues of the linearized
%               dynamical system in parallel_bifurcation_plane_v2


%extract parameters structure
parameters = fin.parameters;
parameters.V_p_0 = V_p_0;

%loop
n1 = length(fin.l1);
n2 = length(fin.l2);

%Create output
fout = fin;
fout.parameters = parameters;

%eigenvalue
fout.eig_Vp = zeros([size(fin.uh) 3]);

for ii=1:n1
    switch fout.type1
        case 'uh'
            parameters.uh = fout.l1(ii);
        case 'Q_tot'
            parameters.Q_tot = fout.l1(ii);
        case 'n_c'
            parameters.n_c = fout.l1(ii);
        case 'L'
            parameters.L = fout.l1(ii);
        case 'V_p'
            warning('V_p_0 set as parameter 1, overwritten here by specified V_p_0 input');
    end
    for jj=1:n2
        v_in(1) = fout.S_R(ii,jj);
        v_in(2) = fout.S_K(ii,jj);
        v_in(3) = fout.N(ii,jj);
        switch type2
            case 'uh'
                parameters.uh = fout.l2(jj);
            case 'Q_tot'
                parameters.Q_tot = fout.l2(jj);
            case 'n_c'
                parameters.n_c = fout.l2(jj);
            case 'L'
                parameters.L = fout.l2(jj);
            case 'V_p'
                warning('V_p_0 set as parameter 2, overwritten here by specified V_p_0 input');
        end
        fout.eig_Vp(ii,jj,:) = parallel_spectrum(v_in,parameters,'storage');
    end
end

end
