function parameters = parallel_network_parameters_v2
% parameters = parallel_network_parameters_v2
%Outputs parameters corresponding to network simulations on the standard
%distributed storage set-up, here with 100 conduits in parallel. No
%bifurcation or stability data are computed by contrast with
%parallel_network_parameters
%this below correspond to the 'standard' values given by scales_network_hlaups_alt


%physical parameters
    parameters.L = 11.5713;
    parameters.n_c = 100;
    parameters.uh = .2713;     
    parameters.uh_bar = 1;
    parameters.V_p_0 = 1.95;   %this corresponds to gamma = .0039 if we assume V_p represents the total integrated volume along a single channel; half this value is also plausible
    parameters.m_store = 0;     %storage capacity does not change with sliding velocity
    parameters.Psi_0 = 1;
    parameters.c_1 = 1;
    parameters.c_2 = 1;
    parameters.c_3 = 1;
    parameters.alpha = 5/4;
    parameters.beta = 3/2;
    parameters.n_Glen = 3;
    parameters.S_0_R = 200;
    parameters.S_0_K = 200;
    parameters.T = 1;
    parameters.nu = 1;

end

