function v_out = parallel_initguess(parameters,type)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

if nargin < 2
    type = 'channel';
end

%unpack parameters
L = parameters.L;           %domain length
n_c = parameters.n_c;       %number of conduits in parallel
Psi_0 = parameters.Psi_0;   %reduced potential gradient 
c_1 = parameters.c_1;       %relates opening rate to Q*Psi
c_2 = parameters.c_2;       %relates closure rate to s*N*n
c_3 = parameters.c_3;       %relates discharge Q to S^alpha*Psi^beta
alpha = parameters.alpha;   %exponent in dependence of discharge Q on cross-section S
beta = parameters.beta;     %exponent in dependence of discharge Q on hydraulic gradient Psi, same convention as in Schoof et al 2012 / Hewitt et al 2012 so 'frozen-time' problenm for N only becomes beta-Laplacian (i.e. p-Laplacian with p=beta)
n_Glen = parameters.n_Glen; %Glen's law exponent
uh = parameters.uh;         %cavity opening rate
S_0_R = parameters.S_0_R;   %cut-off size for cavity opening for  'channel' element
S_0_K = parameters.S_0_K;   %cut-off size for cavity opening for 'cavity' elements
T = parameters.T;           %tortuosities for 'cavities'
nu = parameters.nu;         %step size ratio for 'channel'
Q_tot = parameters.Q_tot;   %total discharge through system


switch type
    case 'channel'
        S_R = (Q_tot/c_3/Psi_0^(beta-1))^(1/alpha);
        N = (c_1*Q_tot*Psi_0/c_2/S_R)^(1/n_Glen);
        S_K = uh/(uh/S_0_K+c_2*N^n_Glen);
    case 'cavities'
        S_K = (Q_tot*T^(beta-1)/n_c/c_3/Psi_0^(beta-1))^(1/alpha);
        N = (uh*(1-S_K/S_0_K)/c_2/S_K)^(1/n_Glen);
        S_R = nu*S_K;
    otherwise error('Incorrect type specified in initial guess computation')
end
if N > Psi_0*L
    N = Psi_0*L;
    S_K = uh/(uh/S_0_K+c_2*N^n_Glen);
    S_R = nu*uh/(nu*uh/S_0_K+c_2*N^n_Glen);
    N = L*(Psi_0-(Q_tot/(n_c-1)/c_3/S_K^alpha)^(1/(beta-1)));
    if N < 0, warning('Negative effective pressure computed'), end
end
v_out = [S_R; S_K; N];

end

