function fout = stability_grid(parameters,q_vals,V_vals)
%fout = stability_grid(parameters,q_vals,V_vals)
%   Computes steady states with parameter structure given by first input
%   'parameters' (defaults to parameters generated by parameter_generator_2018.m
%   with input arguments 'settings' set to settings.lake = true,
%   settings.pointsource = true (see documentation for parameter_generator)
%   water input at first node in parameters (ie, parameters.q_in_0(1)) is
%   overwritten sequentially by the entries in the vector q_vals. For each
%   of these steady states, the spectrum of the linearised system is
%   computed when replacing the water storage capacity at the first node
%   (gamma_store(1)) by the entries in V_vals

if isempty(parameters)
    settings.lake = true; settings.pointsource = true;
    type = 'large';
    parameters = parameter_generator(type,settings);
    parameters.eigfun = false;
end

for ii=1:length(q_vals)
    Q = q_vals(ii);
    faux.Q = Q;
    faux.V = V_vals;
    parameters.q_in_0(1) = Q;
    %compute steady state
    steady_state = line_steady_v2(parameters);
    faux.steady_state = steady_state;
    %extract input for newtwork_stability
    if parameters.Kamb_storage
           v_in = [steady_state.S_R; steady_state.S_K; steady_state.N; steady_state.V_K]; 
        else
           v_in = [steady_state.S_R; steady_state.S_K; steady_state.N];
    end
    for jj=1:length(V_vals)
        parameters.gamma_store(1) = V_vals(jj);
        spectrum = network_stability_v5(v_in,parameters);
        faux.spectrum{jj} = spectrum;
        max(real(spectrum.eigval(isfinite(spectrum.eigval))))
    end
    fout{ii} = faux;
    clear faux
end

end

