function parameters = parameter_generator_2018(type,settings)
%parameters = parameter_generator(settings)
%creates parameters structure for use with stability_grid_v2

%defaults
if nargin < 2 || ~isfield(settings,'lake')
    settings.lake = true;
end
if ~isfield(settings,'pointsource')
    settings.pointsource = true;
end

%grid
switch type
  case 'large'
    L_0 = 26.9799;
  case 'valley'
    L_0 = 11.0293;
end

n_x = 2000;
dx = L_0/n_x;
[parameters.grid, parameters.L, parameters.Phi_0] = line_grid(n_x,dx);  

%other physical parameters
parameters.n_c = 1*ones(size(parameters.L));
parameters.uh = ones(size(parameters.L));
parameters.T = ones(size(parameters.L));
parameters.nu = ones(size(parameters.L));
parameters.Kamb_storage = false;
parameters.uh_K = ones(size(parameters.Phi_0));
parameters.alpha = 5/4;
parameters.beta = 3/2;
parameters.epsilon = 1e-4;
parameters.n_Glen = 3;
parameters.r = 0.9;
parameters.c_1 = 1;
parameters.c_2 = 1;
parameters.c_3 = 1;
parameters.S_0_K = 2e2;
parameters.S_0_R = 2e2;
parameters.V_0_K = 2e2;
parameters.S_P_R = zeros(size(parameters.L));
parameters.S_P_K = zeros(size(parameters.L));
parameters.epsilon_P_R = zeros(size(parameters.L));
parameters.epsilon_P_K = zeros(size(parameters.L));
parameters.k_leak = 0;
if ~settings.lake
    paramteers.gamma_store = ones(size(parameters.Phi_0))*dx/L_0;     %the distributed version
else
    parameters.gamma_store = zeros(size(parameters.Phi_0));
    parameters.gamma_store(1) = 1;                                 %the lake version
end
if  ~settings.pointsource
    parameters.q_in_0 = ones(size(parameters.Phi_0))*dx/L_0;           %the distributed version, gives integrated water input of unity
else
    parameters.q_in_0 = zeros(size(parameters.Phi_0));         %the lake version
    parameters.q_in_0(1) = 1;
end
parameters.gamma_S = zeros(size(parameters.Phi_0));
parameters.N_bdy_nodes = 1e-3*ones(size(parameters.grid.bdy_nodes));
parameters.qscaled = false;

%output
filecounter = 1;
while exist(strcat('data/array_',type,'_',num2str(filecounter)),'file')
  filecounter = filecounter + 1;
end
parameters.filename = strcat('data/array_',type,'_',num2str(filecounter),'.mat');

end

function [grid, L, Phi_0]  = line_grid(n_x,dx)
%Generate line of n_x nodes. Spacing between nodes is dx

%define topology and boundary nodes
grid.n_edges = n_x;
grid.n_nodes = n_x+1;
grid.up_node = (1:n_x)';
grid.down_node = (2:n_x+1)';
grid.bdy_nodes = n_x+1;

%define locations of nodes
grid.x = (0:n_x)'*dx;

%edge lengths and potentials
L = abs(grid.x(grid.up_node)-grid.x(grid.down_node));
Phi_0 = -grid.x;

end