def polarplot(cube,figure=None,axis=None,levels=None,cmap=None,show=True,\
        colorbar=True,ax_cl=None,title=None,rrange = 5.e6,fill_land=True,\
        h_array=None,colorbar_label = None):
    import numpy as np
    import cartopy
    import cartopy.crs as ccrs
    import matplotlib.pyplot as plt
    from arrays import lonwrap
    import numpy.ma as ma
    import copy

    extent = np.array([-1,1,-1,1]) * rrange
    pc = ccrs.PlateCarree()
    nps = ccrs.NorthPolarStereo()

    if levels is None:
        min_data = np.min(cube.data)
        max_data = np.max(cube.data)
        range_data = np.abs(max_data - min_data)
        precision = np.floor(np.log10(range_data)) - 1
        step = 10. ** precision
        start = np.floor(min_data / step) * step
        stop  = np.ceil(max_data * step) / step
        levels = np.arange(start,stop,step)
    

    if figure is None and axis is None:
        figure = plt.figure(figsize = (8,8))

    if axis is None:
        axis = figure.add_axes([.1,.1,.8,.8],projection = nps)

    latitude = cube.coord('latitude').points
    longitude = cube.coord('longitude').points

    data_plot = lonwrap(cube.data)
    longitude_plot = lonwrap(longitude)
    if len(latitude.shape) == 2:
        latitude_plot = lonwrap(latitude)
    else:
        latitude_plot = latitude

    if len(latitude.shape) == 2:
        if hasattr(data_plot,'mask'):
            longitude_mask = data_plot.mask
        else:
            longitude_mask = np.zeros(longitude_plot.shape,dtype='bool')
        longitude_inspect = copy.deepcopy(longitude_plot)

        nx = longitude_plot.shape[1]
        ny = longitude_plot.shape[0]
        jump_pts = ma.masked_array(np.zeros(ny),mask=np.zeros(ny,dtype='bool'))
        for irow in range(ny):
            lon_row_step = longitude_inspect[irow,:] - np.roll(longitude_inspect[irow,:],1)
            jump_pt = np.where(np.abs(lon_row_step) > 180.)
            print irow, jump_pt
            if jump_pt[0].shape[0] == 0:
                jump_pts.mask[irow] = True
            else:
                jump_pts.data[irow] = jump_pt[0][0]
            if jump_pt[0].shape[0] > 1:
                print 'Warning: row '+str(irow)+' has more than 1 jump point'

        print jump_pts
        min_jump = ma.min(jump_pts)
        max_jump = ma.max(jump_pts)

        before_jump_sect = {'ilow':0, 'ihigh':min_jump-1, 'jlow':0,\
               'jhigh': ny, 'shiftlon':False}
        within_jump_sect = {'ilow':min_jump-2, 'ihigh':max_jump+1, 'jlow':0,\
               'jhigh': ny, 'shiftlon':True}
        after_jump_sect  = {'ilow':max_jump, 'ihigh':nx, 'jlow':0,\
               'jhigh': ny, 'shiftlon':False}
        plot_sections = [before_jump_sect,within_jump_sect,after_jump_sect]

        for isect in plot_sections:
            ilow = isect['ilow']
            ihigh = isect['ihigh']
            jlow = isect['jlow']
            jhigh = isect['jhigh']

            print ilow, ihigh, jlow, jhigh

            longitude_sect = longitude_plot[jlow:jhigh,ilow:ihigh]
            latitude_sect  = latitude_plot[jlow:jhigh,ilow:ihigh]
            data_sect      = data_plot[jlow:jhigh,ilow:ihigh]

            if isect['shiftlon']:
                i1 = np.where(longitude_sect <= 180.)
                i2 = np.where(longitude_sect > 180.)
                longitude_sect[i2] = longitude_sect[i2] - 360.
                
            clev = axis.contourf(longitude_sect,latitude_sect,data_sect,\
                levels=levels, cmap=cmap, transform = pc)

    else:
        clev = axis.contourf(longitude_plot,latitude_plot,data_plot,\
                levels=levels, cmap=cmap, transform = pc)

    if h_array is not None:
        data_hatch = lonwrap(h_array)
        clev_h = axis.contourf(longitude_plot,latitude_plot,data_hatch,\
                hatches=['-'],colors='none', transform = pc)

    axis.set_extent(extent,crs=nps)

    if fill_land:
        axis.add_feature(cartopy.feature.LAND)

    axis.add_feature(cartopy.feature.COASTLINE)

    if title is None:
        title = cube.name()

    axis.set_title(title)

    if colorbar:
        if ax_cl is None:
            ax_cl = figure.add_axes([.2,.05,.6,.02])

        plt.colorbar(clev,ax_cl,orientation='horizontal')

        if colorbar_label is None:
            colorbar_label = cube.name() + ' '+ cube.units.__str__()

        ax_cl.text(.5,-1.8,colorbar_label,ha='center')

    if show:
        plt.show()

    return clev
