def required_stash(cpt_id):
    import variables
    varnames = required_vars(cpt_id)
    unique_variables = [variables.UniqueVariable(varname) for varname in \
        varnames]
    stash_codes = [uvar.stash_code for uvar in unique_variables]
    return stash_codes

def required_vars(cpt_id):
    formulae = budget_terms()[cpt_id]
    varnames = []
    for key in formulae.keys():
        varnames = varnames + formulae[key][0]
    
    return list(set(varnames))

def cpt_id(variable):
    bt = budget_terms()
    found_var = False
    cpt_ids = bt.keys()
    cpt_count = 0
    while found_var == False:
        rvars = bt[cpt_ids[cpt_count]].keys()
        found_var = variable in rvars
        cpt_count += 1

        if cpt_count == len(cpt_ids):
            print 'Could not find variable'
            return None

    return cpt_ids[cpt_count-1]


def determine_formulae(variable,cpt_id,files):
    import cube_magic as cm
    formulae_list = budget_terms()[cpt_id][variable]
    for formula in formulae_list:
        if cm.fields_present_multi(files,formula[0]):
            return formula    
    

def budget_terms():
    return_value = {\
        'TOA':{\
                 'SW_down_TOA':[(['toa_incoming_shortwave_flux'],'var1')],\
                 'SW_up_TOA':[(['toa_outgoing_shortwave_flux'],'-1.*var1')],\
                 'LW_up_TOA':[(['toa_outgoing_longwave_flux'],'-1*var1')],\
             },\
        'ICE_STATE':{\
                 'Ice_extent':[(['sea_ice_area_fraction'],'ff.extfn(var1)')],\
                 'Ice_area'  :[(['sea_ice_area_fraction'],'var1')],\
                 'Ice_volume':[(['sea_ice_thickness'],'var1')],\
                 'Snow_volume':[(['surface_snow_thickness'],'var1')],\
             },\
        'SFC':{\
                  'SW_down':[(['surface_downwelling_shortwave_flux'],'var1')],\
                  'SW_up':[(['surface_net_downward_shortwave_flux','surface_downwelling_shortwave_flux'],'var1-var2')],\
                  'SW_net':[(['surface_net_downward_shortwave_flux'],'var1')],\
                  'LW_down':[(['surface_downwelling_longwave_flux'],'var1')],\
                  'LW_up':[(['surface_net_downward_longwave_flux','surface_downwelling_longwave_flux'],'var1-var2')],\
                  'LW_net':[(['surface_net_downward_longwave_flux'],'var1')],\
                  'Sensible_heat_flux': [(['surface_upward_sensible_heat_flux'],'-1.*var1')],\
                  'Latent_heat_flux':[(['surface_upward_latent_heat_flux'],'-1.*var1')],\
                  'Total_snowfall':[(['snowfall_flux'],'var1*ccc.Lfresh()')],\
                  'SW_down_CS':[(['surface_downwelling_shortwave_flux_in_air_assuming_clear_sky'],'var1')],\
                  'SW_up_CS':[(['surface_upwelling_shortwave_flux_in_air_assuming_clear_sky'],'-1.*var1')],\
                  'LW_down_CS':[(['surface_downwelling_longwave_flux_assuming_clear_sky'],'var1')],\
                  'SW_net_CS':[(['surface_downwelling_shortwave_flux_in_air_assuming_clear_sky','surface_upwelling_shortwave_flux_in_air_assuming_clear_sky'],'var1-var2')],\
                  'LW_net_CS':[(['surface_downwelling_longwave_flux_assuming_clear_sky','surface_net_downward_longwave_flux','surface_downwelling_longwave_flux'],'var1+var2-var3')],\
                  'Total_radiative_flux':[(['surface_net_downward_shortwave_flux','surface_net_downward_longwave_flux'],'var1 + var2')],\
                  'Total_turbulent_flux':[(['surface_upward_sensible_heat_flux','surface_upward_latent_heat_flux'],'-1.*(var1 + var2)')],\
                  'Total_surface_flux':[(['surface_net_downward_shortwave_flux','surface_net_downward_longwave_flux','surface_upward_sensible_heat_flux',\
                                         'surface_upward_latent_heat_flux','snowfall_flux'],'var1 + var2 - var3 - var4 + var5*ccc.Lfresh()')],\
                  'SW_CRE':[(['surface_net_downward_shortwave_flux','surface_downwelling_shortwave_flux_in_air_assuming_clear_sky',\
                             'surface_upwelling_shortwave_flux_in_air_assuming_clear_sky'],'var1-var2+var3')],\
                  'LW_CRE':[(['surface_downwelling_longwave_flux','surface_downwelling_longwave_flux_assuming_clear_sky'],'var1-var2')],\
                  'Total_CRE':[(['surface_net_downward_shortwave_flux','surface_downwelling_shortwave_flux_in_air_assuming_clear_sky',\
                                'surface_upwelling_shortwave_flux_in_air_assuming_clear_sky','surface_downwelling_longwave_flux',\
                                'surface_downwelling_longwave_flux_assuming_clear_sky'],'var1-var2+var3+var4-var5')],\
            },\
        'SFC_over_ice':{\
                'SW_down_over_ice':[([5],\
                              'var1')],\
                'SW_up_over_ice':[(['surface_net_downward_shortwave_flux_over_open_sea','surface_downwelling_shortwave_flux','surface_net_downward_shortwave_flux'],\
                     'var3 - var1 - var2')],\
                'SW_net_over_ice':[(['surface_net_downward_shortwave_flux_over_open_sea','surface_net_downward_shortwave_flux'],'var2-var1')],\
                'LW_down_over_ice':[([7],\
                              'var1')],\
                'LW_up_over_ice':[(['surface_net_downward_longwave_flux_over_open_sea','surface_downwelling_longwave_flux','surface_net_downward_longwave_flux'],\
                     'var3 - var1 - var2')],\
                'LW_net_over_ice':[(['surface_net_downward_longwave_flux_over_open_sea','surface_net_downward_longwave_flux'],'var2-var1')],\
                'Sensible_heat_flux_over_ice':[(['surface_upward_sensible_heat_flux_over_open_sea','surface_upward_sensible_heat_flux'],'var1-var2')],\
                'Latent_heat_flux_over_ice':[(['Evaporation flux from open sea','surface_upward_latent_heat_flux'],'var1*ccc.Lfresh()-var2')],\
            },\
        'SFC_STATE':{\
                 'Tsfc':[(['surface_temperature'],'var1')]\
            },\
        'OSF_ALL':{\
                 'Pen_solar_flux':[(['downwelling_photosynthetic_radiative_flux_in_sea_water'],'var1')],\
                 'Diffusive_heat_flux':[(['downwelling_photosynthetic_radiative_flux_in_sea_water','surface_downward_heat_flux_in_sea_water'],'var2-var1')],\
            },\
        'ICE':{\
                 'Topmelt':[(['surface_snow_and_ice_melt_heat_flux'],'var1'),\
                            (['top_ice_melt','top_snow_melt'],'(var1*ccc.rhoi() + var2*ccc.rhos())*ccc.Lfresh()/(ccc.seconds_in_day()*100.)')],\
                 'Fcondtop':[(['downward_top_conductive_flux_in_ice'],'var1')],\
                 'Fcondbot':[(['downward_bottom_conductive_flux_in_ice'],'var1')],\
                 'Ocean_heat':[(['ocean_to_ice_heat_flux','ocean_to_ice_heat_flux_caryhoi','sea_ice_area_fraction'],\
                                    '(var1-var2)*var3'),\
                                    (['ice_to_ocean_heat_flux_CMIP6','sea_ice_area_fraction'],'-1.*var1*var2')],\
            },\
        'ICE_STATE':{\
                 'Ice_extent':[(['sea_ice_area_fraction'],'ff.extfn(var1)')],\
                 'Ice_area'  :[(['sea_ice_area_fraction'],'var1')],\
                 'Ice_volume':[(['sea_ice_thickness'],'var1')],\
                 'Snow_volume':[(['thickness_of_snow_on_sea_ice'],'var1')]
             },\
        'ICE_CAT':{\
                 'Category_ice_area'  :[(['category_ice_area'],'var1')],\
                 'Category_ice_volume':[(['category_ice_volume'],'var1')],\
                 'Category_snow_volume':[(['category_snow_volume'],'var1')],\
            },\
       }

    return return_value


def stash_codes():
    return_value = {\
        'TOA':[(1,2,205),(1,1,207),(1,1,208)],\
        'SFC':[(1,1,235),(1,1,201),(1,2,201),(1,2,207),\
               (1,3,234),(1,3,217),(1,5,215)]
        }
    return return_value


def cmip_cpts(tprof,cpt_id):
    dic = {\
        'TOA':\
          ['atmos',\
          {'mon':'Amon',}],\
        'SFC':\
          ['atmos',\
          {'mon':'Amon',}],\
        'ICE_STATE':\
          ['seaIce',\
          {'mon':'OImon',}]\
          }
    return (dic[cpt_id][0], dic[cpt_id][1][tprof])
