import iris
import numpy as np
import matplotlib.pyplot as plt
import pylab
from arrays import wrap
import cube_magic as cm
import iris.coord_categorisation as icc
import timemod
import regions
import datetime as dt
import copy
from matplotlib.font_manager import FontProperties

outfile_eps = '/home/h01/hadax/graphics/PhD/Papers/Dec2013_HadGEM2_energy_budget/v2.2_figs/F6_flux_contribution_fillplot.eps'
outfile_png = '/home/h01/hadax/graphics/PhD/Papers/Dec2013_HadGEM2_energy_budget/v2.2_figs/F6_flux_contribution_fillplot.png'

font_large = FontProperties(size=20)
font_medium = FontProperties(size=15)

radiation_datasets = ['CERES','ISCCP-FD','ERAI']
start_month = 5
model = 'HadGEM2_ES'
experiment = 'Hist1'
model_year_start = 1980
model_year_end = 1999
region_name = 'Arctic_Ocean.1'

nc = 5
nrd = len(radiation_datasets)

data_array = np.zeros((nrd,nc,12))
xx_plot = np.arange(-.5,13,1)
width = .1
xgap = .18


compare_file = '/data/local/hadax/PhD/Attribution/HadGEM2_ES/Hist1/monthly/'+\
    'hadgom/aux/flux_anomaly.nc'
compare_field = iris.load_cube(compare_file)
regions.reduce_to_region(compare_field,region_name,'hadgom')
cm.llbounds(compare_field)
aw = iris.analysis.cartography.area_weights(compare_field)
ts_flux_anomaly = compare_field.collapsed(['latitude','longitude'],\
    iris.analysis.MEAN, weights = aw)

n_model_years = model_year_end - model_year_start + 1
translate_indices = (np.arange(12) + start_month - 1) % 12

for (ird,radiation_dataset) in enumerate(radiation_datasets):
    contributions = [\
        {'label':    'Ice fraction',\
         'grid': 'n96', \
         'datafile': '/data/local/hadax/PhD/Attribution/'+model+'/'+\
                experiment+'/monthly/n96/output/'+\
            'iifrac.SW_net.NSIDCC-'+radiation_dataset+'.',\
         'plot_color': '#ffd0d0'}, \
        {'label':    'Melt onset', \
         'grid': 'n96', \
         'datafile': '/data/local/hadax/PhD/Attribution/'+model+'/'+\
                experiment+'/monthly/n96/output/'+\
            'iimelt.SW_net.melt_onset.',\
         'plot_color': '#ffa0a0'}, \
        {'label':    'Ice thickness',\
         'grid': 'hadgom', \
         'datafile': '/data/local/hadax/PhD/Attribution/'+model+'/'+\
                experiment+'/monthly/hadgom/output/'+\
            'Ice_volume.LW_net.'+radiation_dataset+'-PIOMAS.',\
         'plot_color': '#e0e0e0'},\
        {'label':    'Downwelling SW', \
         'grid': 'n96', \
         'datafile': '/data/local/hadax/PhD/Attribution/'+model+'/'+\
                experiment+'/monthly/n96/output/'+\
            'SW_down.SW_net.NSIDCC-melt_onset-PIOMAS-'+radiation_dataset+'.',\
         'plot_color': '#ffff80'}, \
        {'label':    'Downwelling LW',\
         'grid': 'hadgom', \
         'datafile': '/data/local/hadax/PhD/Attribution/'+model+'/'+\
                experiment+'/monthly/hadgom/output/'+\
            'LW_down.LW_net.'+radiation_dataset+'-PIOMAS.',\
         'plot_color': '#c0c0ff'}]

    for (ic,contribution) in enumerate(contributions):
        print 'Calculating contribution '+contribution['label']
        accum_array = np.zeros(12)

        for year in range(model_year_start,model_year_end+1):
            datacube = iris.load_cube(contribution['datafile'] + str(year) + '.nc')
            regions.reduce_to_region(datacube,region_name,contribution['grid'])
            cm.llbounds(datacube)
            aw = iris.analysis.cartography.area_weights(datacube)
            tscube = datacube.collapsed(['latitude','longitude'],iris.analysis.MEAN,weights=aw)
            ind = np.where(tscube.data.mask == True)
            tscube.data.mask[ind] = False
            tscube.data.data[ind] = 0.
            accum_array = accum_array + tscube.data

            if year == model_year_start:
                accum_cube = copy.deepcopy(datacube)
            else:
                ic_cube = copy.deepcopy(accum_cube)
                ic_cube.data = datacube.data
                accum_cube = accum_cube + ic_cube

        contribution['sc_cube'] = accum_cube / n_model_years

        accum_array = accum_array / n_model_years
        sc_plot = accum_array[translate_indices]

        data_array[ird,ic,:] = sc_plot

mean_data_array = np.mean(data_array,axis=0)
std_data_array = np.std(data_array,axis=0)
hu_data_array = copy.deepcopy(mean_data_array)
hu_data_array[:3,:] = 0.
hu_data_array[3:,0] = 0.
hu_data_array[3:,6:] = 0.



mean_data_array[3:,1:6] = 0.
index= np.where(np.abs(mean_data_array) <= 0.1)
mean_data_array[index] = 0.

ylim = (-12,19.3)
figure = plt.figure(figsize=(11,9))
axis = figure.add_axes([.1,.1,.85,.85])

for month in range(1,13):
    month_name = dt.date(1980,month,1).strftime('%b')
    position = (month + 12 - start_month) % 12 + .5
    axis.text(position,ylim[0] - .05 * (ylim[1] - ylim[0]), month_name, fontproperties=font_large,ha='center')
    plt.plot([position+.5]*2,ylim,linestyle='--', color = 'k',zorder = 1)

p1 = wrap(mean_data_array[1,:])
p1 = p1 * (p1 >= 0)

p2 = wrap(mean_data_array[3,:])
p2 = p2 * (p2 >= 0)

p3 = wrap(mean_data_array[0,:])
p3 = p3 * (p3 >= 0)

n1 = wrap(mean_data_array[4,:])
n1 = n1 * (n1 <= 0)

n2 = wrap(mean_data_array[2,:])
n2 = n2 * (n2 <= 0)

border_color = '#808080'
plt.fill_between(xx_plot,np.zeros(14),p1,\
    color = contributions[1]['plot_color'], zorder = 2)
plt.plot(xx_plot,p1,color=border_color,zorder = 3)
plt.fill_between(xx_plot,p1, p1 + p2, \
    color = contributions[3]['plot_color'], zorder = 2)
plt.plot(xx_plot,p1+p2,color=border_color,zorder = 3)
plt.fill_between(xx_plot,p1 + p2, p1 + p2 + p3, \
    color = contributions[0]['plot_color'], zorder = 2)
plt.plot(xx_plot,p1+p2+p3,color=border_color,zorder = 3)

plt.fill_between(xx_plot,n1,np.zeros(14),\
    color = contributions[4]['plot_color'], zorder = 2)
plt.plot(xx_plot,n1,color=border_color,zorder = 3)
plt.fill_between(xx_plot,n2 + n1,n1,\
    color = contributions[2]['plot_color'], zorder = 2)    
plt.plot(xx_plot,n1+n2,color=border_color,zorder = 3)

labelx = [3.5, 1.5, 7.4, 9.0,10.5]
labely = [1., 2.0,-6.14,-2.5, 2.0]
labeltext = ['Surface albedo\nfeedback','Melt\nonset','Thickness-growth\nfeedback',\
    'Downwelling LW','Downwelling SW']
for (ic,contribution) in enumerate(contributions):
    plt.text(labelx[ic],labely[ic],labeltext[ic],ha='center',\
    fontproperties = font_medium)

plt.fill_between([9.1,11.9],[1.5,1.5],[3.2,3.2],color='#ffffff',zorder=2)

plt.fill_between([1.5,3.9],[16,16],[19,19],color='#ffffff',zorder=2)
plt.text(2.8,16.5,'Summer radiative\nflux anomalies\nvery uncertain',ha='center',\
    zorder=3)


plt.plot(xx_plot, wrap(ts_flux_anomaly.data[translate_indices]), \
    marker='o',linewidth = 3, markersize=12,\
    color = '#202020',label = 'Latent heat flux anomaly\nimplied by ice volume anomalies')

axis.legend()
axis.set_ylabel('Induced surface flux anomaly ($W/m^2$)',fontproperties=font_large)

axis.set_xticks(np.arange(0,13))
for label in axis.get_xticklabels():
    label.set_visible(False)

for label in axis.get_yticklabels():
    label.set_fontproperties(font_large)

axis.set_xlim(0,12)
axis.set_ylim(ylim)

pylab.savefig(outfile_eps)
pylab.savefig(outfile_png)
