import numpy as np
import iris
import matplotlib.pyplot as plt
import cartopy.crs as ccrs
import datetime as dt
import copy
import monty
import plot_functions as pf
import pylab
from matplotlib.font_manager import FontProperties

font_large = FontProperties(size=18)

outfile_eps = '/home/h01/hadax/graphics/PhD/Papers/'+\
    'Dec2013_HadGEM2_energy_budget/'+\
    'v2.2_figs/F3_spatial_amplification.eps'
outfile_png = '/home/h01/hadax/graphics/PhD/Papers/'+\
    'Dec2013_HadGEM2_energy_budget/'+\
    'v2.2_figs/F3_spatial_amplification.png'

model = 'HadGEM2_ES'
experiment = 'Hist1'
period = [1980,1999]
hice_month_max = 4
hice_month_min = 10

basedir_ma = '/data/local/hadax/PhD/multiannual_fields/'
rcodes = ['Arctic_Ocean.1','VAR.Envisat','SCICEX']
obs_names = ['PIOMAS','Envisat','subs']
obs_tcodes = ['1980.1999','1993.2000','1980.1999']
mod_tcode = str(period[0]) + '.' + str(period[1])

hg2_hice_cubes = [iris.load_cube(basedir_ma + model + '/' + experiment + '/' + \
   'ICE_STATE/' + 'monthly/' + 'Ice_volume.'+mod_tcode+'.'+rcode+'.nc') \
    for rcode in rcodes]
obs_hice_cubes = [iris.load_cube(basedir_ma + obs_name + '/hadgom/' + \


    'Ice_volume.'+tcode+'.'+rcode+'.nc') for (obs_name,rcode,tcode) in \
    zip(obs_names,rcodes,obs_tcodes)]

xl = .05
yb = .2
xw = .28
xgap = .32
yw = .75

letters = ['(a)','(b)','(c)']
levels = np.arange(-1.,1.01,.2)
cmap = monty.clr_cmap('/home/h01/hadax/IDL/colour_tables/aice_anom.clr')
nps = ccrs.NorthPolarStereo()

figure = plt.figure(figsize=(10,5))

for (icube,(mod_cube,obs_cube)) in \
     enumerate(zip(hg2_hice_cubes,obs_hice_cubes)):
    month_names = [dt.date(1980,month,1).strftime('%b') for month in \
                   [hice_month_max,hice_month_min]]
    mod_indices = [np.where(mod_cube.coord('month').points == month_name) \
                   for month_name in month_names]
    obs_indices = [np.where(obs_cube.coord('month').points == month_name) \
                   for month_name in month_names]
    
    mod_cube_maxmin = iris.cube.CubeList([mod_cube[index[0][0],:,:] \
                   for index in mod_indices])
    obs_cube_maxmin = iris.cube.CubeList([obs_cube[index[0][0],:,:] \
                   for index in obs_indices])

    mod_cube_amp = mod_cube_maxmin[0] - mod_cube_maxmin[1]
    obs_cube_amp = obs_cube_maxmin[0] - obs_cube_maxmin[1]

    obs_cube_amp_cfg = copy.deepcopy(mod_cube_amp)
    obs_cube_amp_cfg.data = obs_cube_amp.data
    anom_cube_amp = mod_cube_amp - obs_cube_amp_cfg

    axis = figure.add_axes([xl+icube*xgap,yb,xw,yw],projection=nps)
    clev = pf.polarplot(anom_cube_amp, levels = levels, cmap = cmap, \
        figure = figure, axis = axis, show = False, colorbar = False, \
        title = ' ')
    axis.set_title(letters[icube],fontproperties = font_large)


ax_cl = figure.add_axes([.2,.14,.6,.05])
plt.colorbar(clev,cax=ax_cl,orientation='horizontal')

for label in ax_cl.get_xticklabels():
    label.set_fontproperties(font_large)

ax_cl.text(.5,-2.5,'Model anomaly in October-April thickness change (m)',ha='center',\
    fontproperties = font_large)

pylab.savefig(outfile_eps)
pylab.savefig(outfile_png)
