import numpy as np
import iris
import matplotlib.pyplot as plt
from arrays import wrap
import datetime as dt
import iris.coord_categorisation as icc
from matplotlib.font_manager import FontProperties
import pylab

model = 'HadGEM2_ES'
experiment = 'Hist1'
region_code = 'Arctic_Ocean.1'
startyear = 1980
endyear = 1999

font_large = FontProperties(size=18)
font_medium = FontProperties(size=15)

tcode = str(startyear) + '.' + str(endyear)

datadir = '/data/local/hadax/PhD/timeseries/'+model+'/'+experiment+'/'+\
    'SFC/monthly/'
outfile_eps = '/home/h01/hadax/graphics/PhD/Papers/'+\
    'Dec2013_HadGEM2_energy_budget/'+\
    'v2.2_figs/F1a_seb_demo.eps'
outfile_png = '/home/h01/hadax/graphics/PhD/Papers/'+\
    'Dec2013_HadGEM2_energy_budget/'+\
    'v2.2_figs/F1a_seb_demo.png'

order = ['SW_down','SW_up','LW_down','LW_up','Sensible_heat_flux',\
    'Latent_heat_flux','Total_snowfall']

components = {\
    'SW_down': ['Downwelling SW','#ff8000'],\
    'SW_up':   ['Upwelling SW', '#ffff00'],\
    'LW_down': ['Downwelling LW', '#ff0000'],\
    'LW_up':   ['Upwelling LW', '#a04000'],\
    'Sensible_heat_flux': ['Sensible heat flux', '#000080'],\
    'Latent_heat_flux':   ['Latent heat flux', '#0000ff'],\
    'Total_snowfall':     ['Heat flux due to snowfall', '#808080']}

xx_plot = np.arange(-.5,13)

figure = plt.figure(figsize=(6.5,7))
axis = figure.add_axes([.18,.3,.8,.66])
for key in order:
    ffile = datadir + key + '.' + tcode + '.' + region_code + '.MEAN.nc'
    ccube = iris.load_cube(ffile)
    #icc.add_month(ccube,'time')
    sc_cube = ccube.aggregated_by('month',iris.analysis.MEAN)
    
    plt.plot(xx_plot,wrap(sc_cube.data),color = components[key][1], \
        label = components[key][0],marker='*')

for label in axis.get_xticklabels():
    label.set_visible(False)

for label in axis.get_yticklabels():
    label.set_fontproperties(font_large)

axis.set_xticks(np.arange(0,13))
ylim = axis.get_ylim()
axis.set_xlim(0,12)
axis.set_ylabel('Energy flux ($W/m^2$)',fontproperties=font_large)
ypt = ylim[0] - .05*(ylim[1]-ylim[0])
for month in range(1,12):
    axis.text(month-.5,ypt,dt.date(1980,month,1).strftime('%b')[0],\
        fontproperties=font_large)
    
axis.legend(bbox_to_anchor = [.53,-.58,.5,.5],prop=font_medium,ncol = 2)
pylab.savefig(outfile_eps)
pylab.savefig(outfile_png)
