#Giri Gopalan
#generate simulations via analytical solutions

#Compute distance to origin vector
x_vals <- seq(0,RANGE,del_x)
y_vals <- seq(RANGE,0,by = -del_y)
M <- RANGE/del_x+1
N <- RANGE/del_y+1
X_val <- matrix(rep(x_vals,M),nrow=M,byrow=TRUE)
Y_val <- matrix(rep(y_vals,M),ncol=M)
D <- sqrt(X_val^2+Y_val^2)
angles <- atan2(Y_val,X_val)
M <- 2*M-1
N <- 2*N-1
H_mat_full <- matrix(rep(0,M*N),nrow=M)
################################
# Generate observations
measurement_var <- 1
#assume we observe the process every half-year
time_period <- .5/del_t
time_samples <- seq(time_period,Time,.5/del_t)
load('/Users/girigopalan/Desktop/Iceland/R_Data/test_B.RData')
#load('/Users/girigopalan/Desktop/Iceland/R_Data/test_C.RData')
#load('/Users/girigopalan/Desktop/Iceland/R_Data/test_D.RData')
#load('/Users/girigopalan/Desktop/Iceland/R_Data/test_E.RData')
H_mat <- H_true_mat(D,t_0)
H_mat[which(is.nan(H_mat))] <- 0
H_mat_full[1:((M-1)/2+1),((M-1)/2+1):M] <- H_mat
H_mat_full[1:((M-1)/2+1),((M-1)/2+1):1] <- H_mat
H_mat_full[M:((M-1)/2+1),((M-1)/2+1):M] <- H_mat
H_mat_full[M:((M-1)/2+1),((M-1)/2+1):1] <- H_mat
Y_init <- as.vector(H_mat_full)
S <- H_mat_full+R
load('/Users/girigopalan/Desktop/Iceland/R_Data/space_samples.RData')
Y <- matrix(rep(0,length(time_samples)*length(space_samples),),ncol=length(space_samples))
no_noise <- matrix(rep(0,length(time_samples)*length(space_samples),),ncol=length(space_samples))
for(i in 1:length(time_samples)){
  t_cur <- time_samples[i]
  H_mat <- H_true_mat(D,t_0+del_t*t_cur)
  #for test case D
  H_mat[which(is.nan(H_mat))] <- 0
  H_mat_full[1:((M-1)/2+1),((M-1)/2+1):M] <- H_mat
  H_mat_full[1:((M-1)/2+1),((M-1)/2+1):1] <- H_mat
  H_mat_full[M:((M-1)/2+1),((M-1)/2+1):M] <- H_mat
  H_mat_full[M:((M-1)/2+1),((M-1)/2+1):1] <- H_mat
  new_vec <- as.vector(H_mat_full)
  #simulate measurement error
  no_noise[i,] <- new_vec[space_samples]#+rnorm(mean=0,sd=sqrt(measurement_var),n=length(space_samples))
  Y[i,] <- no_noise[i,]+rnorm(mean=0,sd=sqrt(measurement_var),n=length(space_samples))
}
u_0 <- (1-(M*N-2)*measurement_var/sum(Y_init^2))*Y_init
t_cur <- Time
H_mat <- H_true_mat(D,t_0+del_t*t_cur)
H_mat[which(is.nan(H_mat))] <- 0
H_mat_full[1:((M-1)/2+1),((M-1)/2+1):M] <- H_mat
H_mat_full[1:((M-1)/2+1),((M-1)/2+1):1] <- H_mat
H_mat_full[M:((M-1)/2+1),((M-1)/2+1):M] <- H_mat
H_mat_full[M:((M-1)/2+1),((M-1)/2+1):1] <- H_mat
u_final <- as.vector(H_mat_full)[space_samples]+rnorm(mean=0,sd=sqrt(measurement_var),n=length(space_samples)
#J-S-Estimate
u_final <- (1-(M*N-2)*measurement_var/sum(u_final^2))*u_final

#calculate distance matrix for observations
full_X_val <- matrix(rep(0,M*N),nrow=M)
full_Y_val <- matrix(rep(0,M*N),nrow=M)
full_X_val[1:((M-1)/2+1),((M-1)/2+1):M]  <- X_val
full_X_val[1:((M-1)/2+1),((M-1)/2+1):1] <- -X_val
full_X_val[M:((M-1)/2+1),((M-1)/2+1):M] <- X_val
full_X_val[M:((M-1)/2+1),((M-1)/2+1):1] <- -X_val
full_Y_val[1:((M-1)/2+1),((M-1)/2+1):M] <- Y_val
full_Y_val[1:((M-1)/2+1),((M-1)/2+1):1]  <-  Y_val
full_Y_val[M:((M-1)/2+1),((M-1)/2+1):M] <- -Y_val
full_Y_val[M:((M-1)/2+1),((M-1)/2+1):1]  <- -Y_val

Y_vec <- as.vector(full_Y_val)
X_vec <- as.vector(full_X_val)
coords_mat <- cbind(X_vec[space_samples],Y_vec[space_samples])
basal_mat <- cbind(X_vec,Y_vec)

D_mat_full <- matrix(rep(0,M*N),nrow=M)
D_mat_full[1:((M-1)/2+1),((M-1)/2+1):M] <- D
D_mat_full[1:((M-1)/2+1),((M-1)/2+1):1] <- D
D_mat_full[M:((M-1)/2+1),((M-1)/2+1):M] <- D
D_mat_full[M:((M-1)/2+1),((M-1)/2+1):1] <- D

margin <- which(D_mat_full[space_samples] > 600000)
interior <- intersect(which(D_mat_full[space_samples] <= 600000),which(D_mat_full[space_samples] >= 100000))
dome <- which(D_mat_full[space_samples] < 100000)

observed_index <- space_samples
unobserved_index <- setdiff(seq(length(H_mat_full)),space_samples)


