#Giri Gopalan

# TEST CASE E
# Analytical solutions


R_0 <- 30*10^3
H_0 <- 1000
gamma <- (31556926)*2*B*(rho*g)^n/(n+2)
t_0 <- 5000
n <- 3
f <- 0
L <- 750*10^3
M_0 <- .3
r_1 <- 200*10^3
r_2 <- 700*10^3
theta_1 <- 10
theta_2 <- 80

C_v <- (2^(n-1)*M_0/gamma)^(1/(2*n+2))
w <- function(r)
{
  L^(1+1/n)-r^(1+1/n)
}
H_v<- function(r)
{
  C_v*w(r)^(n/(2*n+2))
}
H_v_deriv <- function(r)
{
  -.5*C_v*r^(1/n)*w(r)^((-n-2)/(2*n+2))
}
mu <- function(r,theta)
{
  if(r_1 <r && r < r_2 && theta_1 < theta && theta < theta_2)
  {
    return(mu_max*4*(r-r_1)*(r_2-r)*4*(theta-theta_1)*(theta_2-theta)/((r_2-r_1)^2*(theta_2-theta_1)^2))
  }
  return(0)
}
mu_deriv <- function(r,theta)
{
  if(r_1 <r && r < r_2 && theta_1 < theta && theta < theta_2)
  {
    return(mu_max*4*(theta-theta_1)*(theta_2-theta)*(theta_2-theta_1)^(-2)*4*(r_1+r_2-2*r)*(r_2-r_1)^(-2))
  }
  return(0)
}
H_v_d_deriv <- function(r)
{
  -C_v*w(r)^((-3*n-4)/(2*n+2))*(r^((1-n)/n)*w(r)+(n+2)*r^(2/n)/2)/(2*n)
}
M_b <- function(r,theta)
{
  return(-rho*g*(H_v(r)^2*H_v_deriv(r)*(r^(-1)*mu(r,theta)+mu_deriv(r,theta))+mu(r,theta)*H_v(r)*(2*H_v_deriv(r)^2+H_v(r)*H_v_d_deriv(r))))
}
MB <- function(r,theta)
{
  M_0+M_b(r,theta)
}
b <- matrix(rep(0,dim(D)))
H_true <- function(r,t)
{
  return(H_v(r))
}
H_true_mat <- function(mat,t)
{
  output <- matrix(rep(0,dim(mat)[1]*dim(mat)[2]),nrow=dim(mat)[1])
  for(i in 1:dim(mat)[1])
  {
    for(j in 1:dim(mat)[2])
    {
      if(H_true(mat[i,j],t) != 'NaN'){
        output[i,j] <- H_true(mat[i,j],t)
      }
    }
  }
  return(output)
}
#create a matrix grid to test the method
del_x <- 10^5
del_y <- 10^5
M <- RANGE/del_x+1
N <- RANGE/del_y+1
#Compute distance to origin vector
x_vals <- seq(0,RANGE,del_x)
y_vals <- seq(RANGE,0,by = -del_y)
X_coord <- matrix(rep(x_vals,M),nrow=M,byrow=TRUE)
Y_coord <- matrix(rep(y_vals,M),ncol=M)
D <- sqrt(X_coord^2+Y_coord^2)
angles <- atan2(Y_coord,X_coord)*180/pi
H_mat <- matrix(rep(0,M*N),nrow=M)
H_mat_full <- matrix(rep(0,(2*M-1)*(2*M-1)),nrow=2*M-1)
sliding_quad_1 <-matrix(rep(0,dim(D)[1]*dim(D)[2]),nrow=dim(D)[1])
basal <- matrix(rep(0,(2*M-1)*(2*M-1)),nrow=2*M-1)
b <- matrix(rep(0,(2*M-1)*(2*M-1)),nrow=2*M-1)
b_quad_1 <- matrix(rep(0,dim(D)[1]*dim(D)[2]),nrow=dim(D)[1])
H_mat <- H_true(D,t_0)
H_mat[which(is.nan(H_mat))] <- 0
H_mat_full[1:M,M:(2*M-1)] <- H_mat
H_mat_full[1:M,M:1] <- H_mat
H_mat_full[(2*M-1):M,M:(2*M-1)] <- H_mat
H_mat_full[(2*M-1):M,M:1] <- H_mat
M <- dim(H_mat_full)[1]
N <- dim(H_mat_full)[2]
for(i in 1:dim(b_quad_1)[1])
{
  for(j in 1:dim(b_quad_1)[2])
  {
    b_quad_1[i,j] <- MB(D[i,j],angles[i,j])
  }
}
b_quad_1[which(is.nan(b_quad_1))] <- 0
b[1:((M-1)/2+1),((M-1)/2+1):M] <-  b_quad_1 
b[1:((M-1)/2+1),((M-1)/2+1):1] <- b_quad_1
b[M:((M-1)/2+1),((M-1)/2+1):M] <- b_quad_1
b[M:((M-1)/2+1),((M-1)/2+1):1] <- b_quad_1


for(i in 1:dim(sliding_quad_1)[1])
{
  for(j in 1:dim(sliding_quad_1)[2])
  {
    sliding_quad_1[i,j] <- mu(D[i,j],angles[i,j])
  }
}
sliding_quad_1[which(is.nan(sliding_quad_1))] <- 0
basal[1:((M-1)/2+1),((M-1)/2+1):M] <-  sliding_quad_1 
basal[1:((M-1)/2+1),((M-1)/2+1):1] <- sliding_quad_1
basal[M:((M-1)/2+1),((M-1)/2+1):M] <- sliding_quad_1
basal[M:((M-1)/2+1),((M-1)/2+1):1] <- sliding_quad_1
unscaled_sliding <- basal/(mu_max)
H <- H_mat_full
R <- matrix(rep(0,M*N),nrow=M)

##Lax-Wendroff method for the shallow ice approximation

#######################################
#Finite difference helper functions
#takes in a field as a matrix and returns first order finite x differences at every point in the interior rows and columns 
diff_x <- function(F)
{
  X <- matrix(rep(0,M*N),nrow=M)
  #handle the left and right boundaries first
  j <- 1
  for(i in 1:M)
  {
    #one sided differences for boundary
    X[i,j] <- (F[i,j+1]-F[i,j])/del_x
  }
  j <- N
  for(i in 1:M)
  {
    #one sided differences for boundary
    X[i,j] <- (F[i,j]-F[i,j-1])/del_x
  }
  #handle interior with central differences
  for(i in 1:M)
  {
    for(j in seq(2,N-1,1))
    {
      #central difference for interior
      X[i,j] <- (F[i,j+1]-F[i,j-1])/(2*del_x)
    }
  }
  return(X)
}
#takes in a field as a matrix and returns first order finite y differences at every point in the interior rows and columns
diff_y <- function(F)
{
  X <- matrix(rep(0,M*N),nrow=M)
  #handle the upper and lower boundaries first
  i <- 1
  for(j in 1:N)
  {
    #one sided differences for boundary
    X[i,j] <- (F[i,j]-F[i+1,j])/del_y
  }
  i <- M
  for(j in 1:N)
  {
    #one sided differences for boundary
    X[i,j] <- (F[i-1,j]-F[i,j])/del_y
  }
  #handle interior with central differences
  for(i in seq(2,M-1,1))
  {
    for(j in 1:N)
    {
      #central difference for interior
      X[i,j] <- (F[i-1,j]-F[i+1,j])/(2*del_y)
    }
  }
  return(X)
}
bar_H <- function(F)
{
  X <- matrix(rep(0,M*N),nrow=M)
  for(i in 2:(M-1))
  {
    for(j in 2:(N-1))
    {
      X[i,j] <- mean(c(F[i-1,j],F[i+1,j],F[i,j-1],F[i,j+1],F[i,j]))
    }
  }
  return(X)
}
R_x <- diff_x(R)
R_xx <- diff_x(R_x)
R_y <- diff_y(R)
R_yy <- diff_y(R_y)
R_xy <- diff_y(R_x)

forward_compute <- function(H_cur,S,R,theta,cur_t)
{
  B_prop <- theta[1]
  C_0_gamma <- 31556926*theta[2]*unscaled_sliding
  C_star <- (31556926)*(2*B_prop)*((rho*g)^n)/(n+2)
  #########################################
  #Calculate necessary finite difference matrices
  H_x <- diff_x(H_cur) 
  S_x <- H_x+R_x
  H_xx <- diff_x(H_x)
  S_xx <- H_xx+R_xx
  H_y <- diff_y(H_cur)
  S_y <- H_y+R_y
  H_yy <- diff_y(H_y)
  H_xy <- diff_y(H_x)
  S_yy <- H_yy+R_yy
  S_xy <- H_xy+R_xy
  S_yx <- S_xy
  H <- bar_H(H_cur)
  #########################################
  alpha <- (S_x^2+S_y^2)^((n-1)/2)
  alpha_x <- (n-1)/2*(S_x^2+S_y^2)^((n-3)/2)*(2*S_x*S_xx+2*S_y*S_yx)
  alpha_y <- (n-1)/2*(S_x^2+S_y^2)^((n-3)/2)*(2*S_y*S_yy+2*S_x*S_xy)
  u_bar <- -C_0_gamma*(-rho*g_const*H*S_x)+C_star*alpha*H^n*(-1*H*S_x)
  v_bar <- -C_0_gamma*(-rho*g_const*H*S_y)+C_star*alpha*H^n*(-1*H*S_y)
  T_1 <- 2*H*H_x*(H_x+R_x)+H^2*(H_xx+R_xx)
  T_2 <- alpha_x*(H^(n+2)*H_x+H^(n+2)*R_x)+alpha*((n+2)*H^(n+1)*H_x^2+(n+2)*H^(n+1)*H_x*R_x+H^(n+2)*H_xx+H^(n+2)*R_xx)
  neg_UH_x <- -C_0_gamma*rho*g_const*T_1+C_star*T_2
  T_3 <- 2*H*H_y*(H_y+R_y)+H^2*(H_yy+R_yy)
  T_4 <- alpha_y*(H^(n+2)*H_y+H^(n+2)*R_y)+alpha*((n+2)*H^(n+1)*H_y^2+(n+2)*H^(n+1)*H_y*R_y+H^(n+2)*H_yy+H^(n+2)*R_yy)
  neg_VH_y <- -C_0_gamma*rho*g_const*T_3+C_star*T_4
  H_t <- neg_UH_x+neg_VH_y+b

  H_tx <- diff_x(H_t)
  H_ty <- diff_y(H_t)
  H_txx <- diff_x(H_tx)
  H_tyy <- diff_y(H_ty)
  H_tyx <- diff_x(H_ty)
  
  alpha_t <- (n-1)/2*(S_x^2+S_y^2)^((n-3)/2)*(2*S_x*H_tx+2*S_y*H_ty)
  alpha_tx <- diff_x(alpha_t)
  alpha_ty <- diff_y(alpha_t)
  
  T_1tx <- 2*H_t*H_x^2+4*H*H_x*H_tx+2*H*H_tx*R_x+2*H_t*H_x*R_x+2*H*H_t*H_xx+H^2*H_txx+2*H*H_t*R_xx
  T_5x <- alpha_tx*H^(n+2)*H_x
  T_6x <- alpha_tx*H^(n+2)*R_x
  T_7x <- alpha_x*((n+2)*H^(n+1)*H_t*H_x+H^(n+2)*H_tx+(n+2)*H^(n+1)*H_t*R_x)
  T_8x <- alpha_tx*H^(n+2)*H_x+alpha_x*(n+2)*H^(n+1)*H_t*H_x+alpha_x^(n-1)*H^(n+2)*H_tx
  T_9x <- alpha_tx*H^(n+2)*R_x+alpha_x*(n+2)*H^(n+1)*H_t*R_x
  T_10x <- alpha_t*(n+2)*H^(n+1)*H_x^2+alpha*(n+2)*(n+1)*H^n*H_t*H_x^2
  T_11x <- alpha*(n+2)*H^(n+1)*2*H_x*H_tx
  T_12x <- alpha_t*(n+2)*H^(n+1)*H_x*R_x+alpha*(n+2)*(n+1)*H^n*H_t*H_x*R_x+alpha*(n+2)*H^(n+1)*H_tx*R_x
  T_13x <- 0 #alpha*(n+2)*H^(n+1)*H_x*R_xt
  T_14x <- alpha_t*H^(n+2)*H_xx
  T_15x <- alpha*(n+2)*H^(n+1)*H_t*H_xx
  T_16x <- alpha*H^(n+2)*H_txx
  T_17x <- alpha_t*H^(n+2)*R_xx
  T_18x <- alpha*(n+2)*H^(n+1)*H_t*R_xx
  T_19x <- 0 #alpha*H^(n+2)*R_xxt
  T_2tx <- T_5x+T_6x+T_7x+T_8x+T_9x+T_10x+T_11x+T_12x+T_13x+T_14x+T_15x+T_16x+T_17x+T_18x+T_19x
  
  T_1ty <- 2*H_t*H_y^2+4*H*H_y*H_ty+2*H*H_ty*R_y+2*H_t*H_y*R_y+2*H*H_t*H_yy+H^2*H_tyy+2*H*H_t*R_yy
  T_5y <- alpha_ty*H^(n+2)*H_y
  T_6y <- alpha_ty*H^(n+2)*R_y
  T_7y <- alpha_y*((n+2)*H^(n+1)*H_t*H_y+H^(n+2)*H_ty+(n+2)*H^(n+1)*H_t*R_y)
  T_8y <- alpha_ty*H^(n+2)*H_y+alpha_y*(n+2)*H^(n+1)*H_t*H_y+alpha_y^(n-1)*H^(n+2)*H_ty
  T_9y <- alpha_ty*H^(n+2)*R_y+alpha_y*(n+2)*H^(n+1)*H_t*R_y
  T_10y <- alpha_t*(n+2)*H^(n+1)*H_y^2+alpha*(n+2)*(n+1)*H^n*H_t*H_y^2
  T_11y <- alpha*(n+2)*H^(n+1)*2*H_y*H_ty
  T_12y <- alpha_t*(n+2)*H^(n+1)*H_y*R_y+alpha*(n+2)*(n+1)*H^n*H_t*H_y*R_y+alpha*(n+2)*H^(n+1)*H_ty*R_y
  T_13y <- 0 #alpha*(n+2)*H^(n+1)*H_y*R_yt
  T_14y <- alpha_t*H^(n+2)*H_yy
  T_15y <- alpha*(n+2)*H^(n+1)*H_t*H_yy
  T_16y <- alpha*H^(n+2)*H_tyy
  T_17y <- alpha_t*H^(n+2)*R_yy
  T_18y <- alpha*(n+2)*H^(n+1)*H_t*R_yy
  T_19y <- 0 #alpha*H^(n+2)*R_yyt
  T_2ty <- T_5y+T_6y+T_7y+T_8y+T_9y+T_10y+T_11y+T_12y+T_13y+T_14y+T_15y+T_16y+T_17y+T_18y+T_19y
  
  neg_UH_xt <- -C_0_gamma*rho*g_const*T_1tx+C_star*T_2tx
  neg_VH_yt <- -C_0_gamma*rho*g_const*T_1ty+C_star*T_2ty
  
  H_tt <- neg_UH_xt+neg_VH_yt
  #########################################
  #Forward compute
  H_cur <- H_cur+H_t*del_t+H_tt*del_t^2*.5
  H_cur[which(H_cur < 0)] <- 0
  S <- H_cur+R
  return(as.vector(H_cur))
}

###test the finite difference solution...
H_cur <- matrix(u_0,nrow=M)
theta <- c(B,mu_max)
for(index in 1:200)
{
  H_cur <- matrix(forward_compute(H_cur,H_cur+R,R,theta,t_0+del_t*(index-1)),nrow=M)
}
