#initialize fundamental constants and load necessary R packages

#set the working directory
setwd('/Users/girigopalan/Desktop/Iceland')

#load packages
library(FastGP)
library(mvtnorm)
library(MASS)

#load R data file for appropriate test case B-E
load('/Users/girigopalan/Desktop/Iceland/R_Data/test_C.RData')
H <- H_mat_full
persp(H,theta=60,col='blue',shade=.1)

# x-width
del_x <- 10^5
#y-width
del_y <- 10^5
#t step
del_t <- .1
#number of time points (20 years)
Time <- 20/del_t

#max range to go out to
RANGE <- 10^6
M <- RANGE/del_x+1
N <- RANGE/del_y+1
M <- 2*M-1
N <- 2*N-1

#flat bedrock
R <- matrix(rep(0,M*N),ncol=N)
#fundamental physical constants
C_0 <- 0
gamma <- 0
rho <- 910
g <- 9.80665
g_const <- 9.80665
n <- 3
B <- 10^(-16)/(31556926)
mu_max <- 2.5*10^(-11)
C_1 <- (31556926)*(2*B)*((rho*g)^n)/(n+2)
R_0 <- 750*10^3
H_0 <- 3600
lambda <- 0
f <- 0
