##==== HEADER ========================================================================
## 
## Purpose:
## This is a script to plot temperatur data from British Columbia
## Ministry of Forest, Land and Natural Resources Operation
##
## Modification History:
## code generation -- January 2013, Hasi
##
## Autors: 
## Hasi (Andreas Hasler), andreas_hasler@gmx.ch, BC Forest Dept.
## 
## Description:		Temperature Time Series dataframes are loaded(files TTSws.RData ;
##  				run "load_TTS.R" if not available) and a time series and MAT plot of
##  				one variable is generated. 
##
## Dependencies:		Ttools.R (own toolbox for temperature timeseries treatment
## 				caTools (R-library)
##
## I/O, variables and units:
## input:			sensor ID, name of variable to plot (plv), begin and end date
##				list of GST and WX sensors(csv files specified in 'gstlist' and 'wxlist' )
##				path (given below under control variable "path") 		
##				WX and GST data from RData files in "path"/RData/
##				 
## variables:		sensorID = ID for selection on the files to be loaded
##				path = absolute path of data files
##				d = dataframe with : t (time), T (temp),   
## 
## units:			t is in inported as "mm-dd-yyyy HH:MM:SS AM/PM"
##				t is internaly in R POSIXct
##				T, T1, T2 is temperature in ?C
##					
##						
##======================================================================================

##======================================================================================
##   clear wksp, load libraries and own tool (functions)
##======================================================================================

## clear current workspace to avoid env. dependency
#rm(list=ls())

##======================================================================================
##   control variables
##======================================================================================

## select site: ("GUN", "SAX", "POP", ...)
site <- "TET"

## select location
loc <- "N1"

## variable to plot
var <- "Tair"

## timerange as entire years (yyyy or "yyyy") or date ("yyyy-mm-dd") (exact cutting)
tbeg <- 2008
tend <- 2013


## plot line for annual running mean in barplot
yrml<-FALSE


## set plot mode: "png","pdf", "scr" (for screen), or "stu" (for R studio plot pane)
pl <- "scr"

## set file name for meta data file
wxlist <- "meta/PermafrostWxID.csv"
gstlist <- "meta/PermafrostProbeID.csv"

## seasonal means in sep. plot
seas <- FALSE

##======================================================================================
##   preparation
##======================================================================================

## load toolbox "Ttools" (requires R-library "caTools")
source("R_source/Ttools.R")

## get sensor lists and list length
wxlist <- read.csv(wxlist, as.is=TRUE,sep=";")
if(dim(wxlist)[2]==1) wxlist <- read.csv(wxlist, as.is=TRUE)
gstlist <- read.csv(gstlist, as.is=TRUE,sep=";")
if(dim(gstlist)[2]==1) gstlist <- read.csv(gstlist, as.is=TRUE)
lwx<-length(wxlist$site)
lgst<-length(gstlist$site)

## make one large list with all sensors:
slist <- rbind(wxlist,gstlist)
slist <- slist[order(slist$site),]
ll <- lwx + lgst

## get sitename and location name as full names
k <- (slist$site == site)&(slist$location==loc)
sitn <- (slist$sitename[k])[1]
locn <- (slist$locationname[k])[1]

## load data to workspace
if (!exists("TTSWS")) load("RData/TTSws.RData")

## make posix if "yyyy-mm-dd" for exact cutting
if (nchar(tbeg)==10) tbeg <- posix(tbeg)
if (nchar(tend)==10) tend <- posix(tend)

plv <- ""&loc&"_"&var

##======================================================================================
##   processing
##======================================================================================

## geting dataframe of respective sensor assigned to "d"
dfn <- paste("TTS_",site,sep="") 
d <- get(dfn)

##======================================================================================
##   ploting
##======================================================================================

## define grafic device size
plfn <- paste("plots/TTSMAT/",site,plv,sep='')
pldev(x=9,y=5,pld=pl,plfn=plfn)

## make rows and cols on sheet c(rows,cols):
par(mfrow=c(1,1),xpd=FALSE) 

## titles 
title <- paste(sitn,plv, sep=' ')

## plot 
ts.MAT.plot(d,plv=plv,tbeg=tbeg,tend=tend,title=title,yrml=yrml)


## close ploting dev for png or pdf
if ((pl!="scr")&(pl!="stu"))  dev.off()

## for seasonal means seperat plot
if(seas){
 windows(10,3)
 x <- seas.mean(d,cm=1)
 xlim = c(0,(29))-3.2
 barplot(x$T,col="grey")
}

##======================================================================================
##   end
##======================================================================================
