##==== HEADER ========================================================================
## 
## Purpose:
## This is a script to plot temperatur data from British Columbia
## Ministry of Forest, Land and Natural Resources Operation
##
## Modification History:
## code generation -- Feburary 2013, Hasi
##
## Autors: 
## Hasi (Andreas Hasler), andreas_hasler@gmx.ch, BC Forest Dept.
## 
## Description:		Plots MATs and spreads (min to max).
##
##
## I/O, variables and units:
## input:			STATws.RData workspace (generated by procedure "stat_TTSMAT.R")
##					variables: sites, MAT_XXX, YRM_XXX, 
##					Ttools
##		
## output:			plot of MATs
##						
##======================================================================================

## set plot mode: "png","pdf", "scr" (for screen), or "stu" (for R studio plot pane)
pl <- "scr"

## color for pos neg?
colpn <- TRUE

##======================================================================================
##======================================================================================
##======================================================================================
##   main loop through sites
## get list of sites:
sites <- levels(factor(slist$site))
sitns <- levels(factor(slist$sitename))
lsl <- length(sites) ## length of short list

for (k in 1:lsl){	
	## get site name	
	site <- sites[k]
  sitn <- sitns[k]

##======================================================================================
##   preparation
##======================================================================================

## reflist for site
reflist <- read.csv("meta/MAT_ref.csv", as.is=TRUE,sep=";")
if(dim(reflist)[2]==1) reflist <- read.csv("meta/MAT_ref.csv", as.is=TRUE) 
lin <- reflist$site == site
reflist <- reflist[lin,]

## geting MAT
name<-"MAT_"&site
stat<-get(name)

## cut off time and get total values:
mmat <- stat$mean
cl <- dim(mmat)[2]
cols <- 2:cl
lin <- mmat$t == "tot"
nam <- names(stat$mean)[cols]
mmat <- as.numeric(stat$mean[lin,cols])
Tmax <- as.numeric(stat$max[lin,cols])
Tmin <- as.numeric(stat$min[lin,cols])
SD <- as.numeric(stat$stdv[lin,cols])

##======================================================================================
##   plot
##======================================================================================


## define grafic device size
plfn <- paste("plots/MAT/MAT_",site,sep='')
## size depends on length of list
pldev(x=(length(mmat)+1.2)*0.7,y=4,pld=pl,plfn=plfn)

## plot parameters
col <- mmat
col[]<- "grey"
col[Tmax < 0] <- "blue"
col[Tmin > 0] <- "orange"
if (!colpn) col <- "grey"
ylim <- c(-6,6)
xlab <- "temperature time series"
ylab <- "MAT (°C)"

## plot
barpl <- barplot(mmat,main=sitn,names.arg=nam,cex.names=0.8,ylim=ylim,ylab=ylab,xlab=xlab,col=col)
arrows(barpl,Tmin,barpl,Tmax,code=3,angle=90,length=0.1,lwd=2)
abline(h=0)

## close ploting dev for png or pdf
if ((pl!="scr")&(pl!="stu"))  dev.off()

}#   END of main loop through the sites
##======================================================================================
##======================================================================================
##   end
##======================================================================================

