#
# funtion to get one value per footprint
# Author: schmid marc-olivier
### Requirements ################################################################
#input file with column names: ib(ex.ALa01),MD,RD,MAGST
#ib (character 1:3 footprint, character 4:5 iButton (ALa10))
#func needs to be R function (mean,sd,etc...)
###############################################################################

f.Footprint<-function(in.path,in.matrix,in.meta,out.path,out.matrix,func){

### read in data
data	<-	read.csv(in.path&in.matrix,header=T,sep=",")
meta	<-	read.csv(in.path&meta,header=T,sep=",")

data$fp<-substring(data$ib,1,3)


names.fp	<-	levels(as.factor(substring(data$ib,1,3)))

###mean footprint table
fp.mean <- as.data.frame(matrix(ncol = 4, nrow = length(names.fp)))
names(fp.mean)<-c("fp","RD","MD","MAGST")
fp.mean$fp<-names.fp

fp.mean$MAGST<-aggregate(data$MAGST,by=list(substring(data$ib,1,3)),FUN=func)$x

i<-1
for (fp in fp.mean$fp){
#fp<-"BMa"
	d.fp<-data[data$fp==fp,]
	
	d.fp$MD<-julian(strptime(d.fp$MD, "%Y-%m-%d"))
	d.fp$RD<-julian(strptime(d.fp$RD, "%Y-%m-%d"))

	fp.mean$RD[i]<-func(d.fp$RD,na.rm=ifelse(sum(is.finite(d.fp$RD))>=5,T,F))
	fp.mean$MD[i]<-func(d.fp$MD,na.rm=ifelse(sum(is.finite(d.fp$MD))>=5,T,F))

	i<-i+1
}

write.csv(fp.mean,out.path&out.matrix, quote =F, row.names =F)

}
