##==== HEADER ========================================================================
## 
## Purpose:
## This is a script to plot temperatur data from British Columbia
## Ministry of Forest, Land and Natural Resources Operation
##
## Modification History:
## code generation -- January / Feburary 2013, Hasi
##
## Autors: 
## Hasi (Andreas Hasler), andreas_hasler@gmx.ch, BC Forest Dept.
## 
## Description:		Temperature Time Series (TTS) dataframes are loaded (files 
##				TTSws.RData ;run "load_TTS.R" if not available) and time series 
##  				and MAT plots of all variable are generated. 
##  				
## Dependencies:		Ttools.R (own toolbox for temperature timeseries treatment
## 				caTools  (library)
##
## I/O, variables and units:
## input:			
##				path (given below under control variable "path") 		
##				temperature time series (TTS) data from RData files
##        slist (contained in STAWS)
##				 
## variables:		sensorID = ID for selection on the files to be loaded
##				path = absolute path of data files
##				TTS-xxx = dataframe with all temperature data per site
##		
## output:			dataframes and csv files: 	
##				MAT and MAT.csv = mean annual temperature 
##				Tmin = minimum of running annual means 
##				Tmax = maximum of running annual means 
##				stdT = standart of running annual means 
##				FDD, TDD = freezing / thawing degree days
##				DC = number of days with valid data within each year 
##
## units:			t is in inported as "mm-dd-yyyy HH:MM:SS AM/PM"
##				t is internaly in R POSIXct
##				T, T1, T2 is temperature in ?C
##						
##======================================================================================

## clear current workspace to avoid env. dependency
#rm(list=ls())

##======================================================================================
##   control variables
##======================================================================================

## set plot mode: "png" or "scr" (for screen)
pl <- "png"

## timerange as entire years (yyyy or "yyyy") 
tbeg <- 2008
tend <- 2012

## plot line for annual running mean in barplot
yrml<-FALSE

##======================================================================================
##   preparation
##======================================================================================

## load workspace with all data and tools 
if (!exists("STAWS")) load("RData/STATws.RData")

## load toolbox "Ttools" (requires R-library "caTools")
source("R_source/Ttools.R")

## get list of sites:
sites <- levels(factor(slist$site))
lsl <- length(sites) ## length of short list

##======================================================================================
##======================================================================================
##======================================================================================
##   main loop through sites 
for (k in 1:lsl){	
	## get site name	
	site <- sites[k]
	sitn <- (slist$sitename[site==slist$site])[1]

	## geting dataframe of respective sensor assigned to "d"
	dfn <- paste("TTS_",site,sep="") 
	d <- get(dfn)
	l <- dim(d)[2]

	##   loop through variables
	for (j in 2:l){
		## get ploting variable name, location and variable	
		plv <- names(d)[j]
		loc <- strsplit(plv,"_")[1]
		var <- strsplit(plv,"_")[2]

##======================================================================================
##   ploting

		## define grafic device size
		## set new plot window for every five plots at each site
		plfn <- paste("plots/TTSMAT_",sitn,sep='')
		if (j==2) pldev(6,9,pld=pl, plfn=plfn) 
		if (j==7) pldev(6,9,pld=pl, plfn=""&plfn&2) 
		if (j==12) pldev(6,9,pld=pl, plfn=""&plfn&3) 
		if (j==17) pldev(6,9,pld=pl, plfn=""&plfn&4) 
		if (j==22) pldev(6,9,pld=pl, plfn=""&plfn&5) 
		if (j==27) pldev(6,9,pld=pl, plfn=""&plfn&6) 
		if (j >31) stop("more than 30 variables per site not supported!!!")

		## make rows and cols on sheet c(rows,cols):
		if (round((j-2)/5)==((j-2)/5)) par(mfrow=c(5,1),xpd=FALSE) 
		print(paste("ploting sensors",sitn,plv, sep=' '))

		## title 
		tlab <- plv
		title <- paste(site,tlab, sep=' ')

		## call ploting routine
		ts.MAT.plot(d,plv=plv,tbeg=tbeg,tend=tend,title=title,yrml=yrml)

		## close devices for png plots
		if ((round((j-6)/5)==((j-6)/5))&(pl=="png")) {
			dev.off()
		} else {
		if ((j==l)&(pl=="png")) dev.off()
		}

##======================================================================================
		
	} ## end of loop through variables 
}#   END of main loop through the sites
##======================================================================================
##   end
##======================================================================================
