##==== HEADER ========================================================================
## 
## Purpose:
## This is a script to plot temperatur data from British Columbia
## Ministry of Forest, Land and Natural Resources Operation
##
## Modification History:
## code generation -- January / Feburary 2013, Hasi
##
## Autors: 
## Hasi (Andreas Hasler), andreas_hasler@gmx.ch, BC Forest Dept.
## 
## Description:		Plots of running annual means are generated for each field site.
##
## Dependencies:		Ttools.R (own toolbox for temperature timeseries treatment,
## 				(contained in STATws.R workspace)
##
## I/O, variables and units:
## input:			STATws.RData workspace (generated by procedure "stat_TTSMAT.R")
##				contains toolbox and different aggregates of time series
##				for details see header of "stat_TTSMAT.R"
##		
## output:			plot of yearly running mean
##
## units:			t is in inported as "mm-dd-yyyy HH:MM:SS AM/PM"
##				t is internaly in R POSIXct
##				temperature is in ?C
##						
##======================================================================================

## clear current workspace to avoid env. dependency
rm(list=ls())

##======================================================================================
##   control variables
##======================================================================================

## time limits (x-axis) for plotting ("yyyy-mm-dd")
pl_beg <- "2007-06-01"
pl_end <- "2013-01-01"

## set plot mode: "png","pdf", "scr" (for screen), or "stu" (for R studio plot pane)
pl <- "scr"

m <- -120

dl <- 0.5 ## 

miss <- FALSE

##======================================================================================
##   preparation
##======================================================================================

## load workspace with all data and tools 
if (!exists("STAWS")) load("RData/STATws.RData")
source("R_source/Ttools.R")

## get list of sites:
sites <- levels(factor(slist$site))
sites <- sites[sites != "SAX"]
lsl <- length(sites) ## length of short list

## convert plot range to posix
pl_beg <- posix(pl_beg)
pl_end <- posix(pl_end)

textdate<- posix("2007-06-01")
abl <- posix(c("2007-01-01","2008-01-01","2009-01-01","2010-01-01","2011-01-01","2012-01-01","2013-01-01"))

col <- c("grey","lightblue","lightgreen","yellow","orange","pink","magenta")
col <- c("grey","lightgrey","grey","lightgrey","grey","lightgrey","grey")


lwd <- 1

n <- 0

site <- "GUN"

## define grafic device size
plfn <- "plots/completness"
pldev(x=4.5,y=3,pld=pl,plfn=plfn)

## make rows and cols on sheet c(rows,cols):
par(mfrow=c(1,1),xpd=FALSE)

## c(bottom, left, top, right) 
par(mar= c(2, 1, 3, 1) + 0.1)

at <- 1:lsl

##======================================================================================
##======================================================================================
##======================================================================================
##   main loop through sites

for (k in 1:lsl){	
	
	n <- n+3
	
	## get site name	
	site <- sites[k]
	sitn <- (slist$sitename[site==slist$site])[1]

	## geting dataframe of respective sensor assigned to "d"
	dfn <- paste("TTS_",site,sep="") 
	d <- get(dfn)
	l <- dim(d)[2]
	
	d[,2:l] <- (d[,2:l])/(d[,2:l])
	if (miss){
		nas <- d
		nas[,2:l]<- is.na(d[,2:l])
		nas<-ts.df.runmean(nas,dl)
		te <- nas[,2:l]!=0 & nas[,2:l] <= 0.2
		te[!te] <- NA
		nas[,2:l] <- te
	}
	
##======================================================================================
##   ploting
##======================================================================================

	## title 
	title <- "data completeness"
	
	## ploting variables
	ylim <- c(m,-3)
	xlim <- as.POSIXct(c(pl_beg,pl_end))
	ylab <- " "
	xlab <- "time"

	##plot settings:
	lty <- rep(c(1,2,4),times=(ceiling(l/3)))

	## plot first line
	if (k==1) {
		plot(d$t,d[,2]-n,type="p",xlim=xlim,ylim=ylim,col=col[k],yaxt="n", xlab=xlab,main=title,cex=0.1)
		if (miss) points(nas$t,nas[,2]-n,col="red",cex=0.2)
		jst <- 3
	}else jst <-2
	
	## benennung
	at[k] <- 2-n-(l/2)
	text(textdate,2-n-(l/2),sites[k],cex=0.8)
	
	##   loop through the other variables
	for (j in jst:l){
		n <- n+1
		
		## plot other vars
		points(d$t,d[,j]-n ,col=col[k] , cex=0.1)
		if (miss) points(nas$t,nas[,j]+m-n,col="red",cex=0.2)
	}
	
}#   END of main loop through the sites

#par(new=TRUE)
#plot(0,0,yaxp=at,ylab=sites)

abline(v=as.POSIXct(abl),lty=2)

## close ploting dev for png or pdf
if ((pl!="scr")&(pl!="stu"))  dev.off()
##======================================================================================
##======================================================================================
##   end
##======================================================================================
