#!/usr/bin/python -W ignore::DeprecationWarning
"""
Simple function for usage with the netCDF files which plots the
timeseries and displays the header.

To plot file foo.nc:
easy_plot.py foo.nc

Dependencies:
- python 2.5
- netCDF 3 or 4  (http://www.unidata.ucar.edu/software/netcdf/)
- netcdf4-python (http://code.google.com/p/netcdf4-python/)
- matplotlib (http://matplotlib.sourceforge.net/)
"""
# easy_plot 0.1, 15.4.2010
# (c) Mauro Werder: m_werder at sfu dot ca
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or any later version. In particular, any 
# distribution or modification must include this notice.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# http://www.gnu.org/licenses/gpl-3.0.html


import sys, commands
if len(sys.argv)==1:
    print __doc__
    sys.exit(0)
try:
    import netCDF4
except:
    import netCDF3
import pylab as P


P.rc('text', usetex=False)
# open file
ncfile = netCDF4.Dataset(sys.argv[1], 'r')
varibs = ncfile.variables
time = varibs.pop('time')
var_names = varibs.keys()

# Print header
print commands.getoutput('ncdump -h ' + sys.argv[1])

# make user choose which variable to plot
if len(var_names)>2:
    print 'Which variable to plot?\n' + str(
        [str(j) + ': ' + var_names[j] for j
         in range(len(var_names))])
    ind = raw_input('Choose number (Blank for all): ')
else:
    ind = 0
P.figure()
if ind=='':
    # plot all
    num_subplots = len(varibs)
    ind_plot = 1
    ax = None
    for var in varibs.itervalues():
        ax = P.subplot(num_subplots,1,ind_plot, sharex=ax)
        P.plot_date(time[:],
                var[:], '-')
        ind_plot += 1
        P.ylabel(var.long_name + ' (' + var.units +')')
else:
    ind = int(ind)
    var = varibs[var_names[ind]]
    # plot it
    P.plot_date(time[:],
                var[:], '-') 
    P.ylabel(var.long_name + ' (' + var.units +')')

#P.xlabel('Time')
P.title(ncfile.name)

ncfile.close()

P.show()
