import sys

if (sys.version[0] == '2'):
  sys.exit('Please use Python 3.')

import pickle

#Load ensemble data:
ens = pickle.load(open('lhs_ensemble.pickle','rb'))

print('#################################################')
print('Supplementary material for Born & Robinson (2021)')
print('#################################################')
print('')
print('This is a set of four nested python classes.')
print('At the top level, the class \'ens\' contains information about the full ensemble of simulations. As an example, \'ens.size_ens\' is the total number of simulations:')

print('\033[32m' + 'ens.size_ens\t\t\t =', ens.size_ens, '\033[m')
print('')

print('Within \'ens\', there are multiple evaluation classes. \'ens.rmse_1km\' corresponds to the RMSE skill metric on the 1 km ice thickness mask that is used in the paper. \'ens.rmse_1km_deptime\' is based on the Eulerian age tracer. They all contain the RMSE for ice thickness, e.g., \'ens.rmse_1km.rmse_ice_array\' etc. and the runs BEST_all and BEST_ice, which themselves are classes, e.g.: \'ens.rmse_1km.bestrun_all\'')
print('')
print('All runs are also listed in \'ens.run_list\', each defined as a class in the same way as \'ens.rmse_1km.bestrun_all\'. These run classes include details on the specific setup such as the Holocene precipitation parameter for run number 0:')

print('\033[32m' + 'ens.run_list[0].dpr_hol\t\t = ', ens.run_list[0].dpr_hol, '\033[m')
print('')
print('Thus, to find the geothermal heat flux of the run with the best match in total ice thickness, BEST_ice, you can use:')
print('\033[32m' + 'ens.rmse_1km.bestrun_ice.ghf_const = ', ens.rmse_1km.bestrun_ice.ghf_const, '\033[m')
print('')
print('Or find the same run in the list of all runs:')
print('\033[32m' + 'ens.rmse_1km.best_ice\t\t = ', ens.rmse_1km.best_ice, '\033[m')
print('\033[32m' + 'ens.run_list[123].ghf_const\t = ', ens.run_list[ens.rmse_1km.best_ice].ghf_const, '\033[m')
print('')
print('Every run contains the full fields of ice thickness and isochrone depths:')
print('\033[32m' + 'ens.run_list[0].ice.shape\t = ', ens.run_list[0].ice.shape, '\033[m')
print('\033[32m' + 'ens.run_list[0].diso.shape\t = ', ens.run_list[0].diso.shape, '\033[m')
print('')
print('The fourth class are observations, \'ens.obs\'.')

print('#########################################')

