% This script makes figure A1 of the Greene et al paper on methods
% to recover seasonal ice dynamics from ITS_LIVE data. 
% Chad A. Greene, April 2020. 

%% Load data
% Data are from 

load itslive_seasonal_unc % from compute_seasonal_uncertainty.m. 

ph_sigma = permute(1.4826*ph_mad(16,:,:),[2 3 1]);
A_sigma = permute(1.4826*A_mad(16,:,:),[2 3 1]);

%% Make the figure 

figure('pos',[100 200 268 205])
pcolor(interannual_rms,A,ph_sigma')
hold on
shading interp
caxis([0 365/4])
cmocean -tempo
set(gca,'xscale','log','yscale','log')

[C,h] = contour(interannual_rms,A,ph_sigma',[0:15:90],'k');
h.Color = rgb('gray');
clabel(C,h,'fontsize',6,'color',rgb('gray'))

%axis equal
axis([interannual_rms(2) interannual_rms(end) 0.45 max(A)])
ylabel('Seasonal amplitude (m/yr)')
xlabel 'Interannual variability (m/yr)'

h1 = plot(interannual_rms(2:end),interannual_rms(2:end)/3,'--');
h1.Color = rgb('cobalt blue'); 

set(gca,'fontsize',7)

cb = colorbar; 
xlabel(cb,'Phase uncertainty (days)')

% export_fig A_interannual_uncertainty.png -r500