
% This script makes figure 6 of the Greene et al paper on methods
% to recover seasonal ice dynamics from ITS_LIVE data. 
% The data in this plot come from itslive_seasonal_parameter_tests.m. 
% Chad A. Greene, April 2020. 

%% Load data 

load recovered_amp_phase_all_4.mat % from itslive_seasonal_parameter_tests.m

sigma_A = median(abs(Am-A))*1.4826
sigma_phase = median(abs(phm-ph))*1.4826

% Trim to a manageable number of datapoints, as to not crowd the plot too much. 
if true
   N = 10000; 
   A =A(1:N); 
   Am = Am(1:N); 
   interannual_rms = interannual_rms(1:N); 
   ph = ph(1:N); 
   phm = phm(1:N); 
end

%% 

sc = 1; % scatter dot size 
fs = 7;
phasecolorbar = false; 

figure('pos',[100 200 305 465])

subplot(2,1,1)
plot([0 max(A)],[0 max(A)],'color',rgb('gray')) 
hold on
if phasecolorbar
   scatter(A,Am,sc,ph,'filled') 
   cmocean phase
   caxis([1 365.25])
   cb = colorbar; 
   ylabel(cb,'Imposed time of maximum velocity')
   set(cb,'ytick',15:30.4:366,'fontsize',fs,'ydir','reverse')
   cbdate('mmm')
else
   scatter3(A,Am,1./interannual_rms,sc,interannual_rms,'filled') 
   cmocean -turbid
   cb1 = colorbar; 
   ylabel(cb1,'Interannual variability (m yr^{-1})')
   set(cb1,'fontsize',fs)
   caxis([0.5 100])
   set(gca,'colorscale','log')
end
axis equal
axis([0 ceil(max(A)) 0 ceil(max(A))])
xlabel 'Imposed seasonal amplitude (m yr^{-1})'
ylabel 'Recovered seasonal amplitude (m yr^{-1})'
box off
set(gca,'fontsize',fs,'xtick',0:10:100,'ytick',0:10:100)
ax1 = gca;    

subplot(2,1,2)
plot([0 365],[0 365],'color',rgb('gray')) 
hold on
scatter3(ph,phm,A,sc,A,'filled') 
axis equal
axis([0 365 0 365])
cmocean amp 
cb2 = colorbar; 
ylabel(cb2,'Imposed seasonal amplitude (m yr^{-1})','fontsize',fs)
ylabel 'Recovered time of maximum velocity'
xlabel 'Imposed time of maximum velocity'
box off
set(gca,'fontsize',fs)
set(gca,'xtick',15:30.4:366,'ytick',15:30.4:366);
datetick('x','mmm','keeplimits','keepticks')
datetick('y','mmm','keeplimits','keepticks')
ax2 = gca; 

% Move the lower panel up: 
pos = get(gca,'pos');
pos(2) = pos(2)+0.07;
set(gca,'pos',pos)

% Align the colorbars and undo any automatic adjustment. 
pos = ax1.Position; 
cb1.Position(1) = cb2.Position(1); 
ax1.Position = pos; 

% export_fig recovered_amp_phase_all_4.png -r600

%%