% This script makes figure 5 of the Greene et al paper on methods
% to recover seasonal ice dynamics from ITS_LIVE data. 
% Chad A. Greene, April 2020. 

%% Load data 
% These data are the results of different tests that isolated the effects
% of varying the number if iterations, number of image pairs, amount of interannual
% variability, seasonal amplitude, and seasonal phase. 
% The script in which those tests were performed is (now) called
% itslive_seasonal_parameter_tests.m. 

ab = load('itslive_seasonal_iter.mat');
cd = load('itslive_seasonal_Npairs.mat'); 
ef = load('itslive_seasonal_interannual.mat'); 
gh = load('itslive_seasonal_A.mat'); 
ij = load('itslive_seasonal_phase.mat'); 

%% Plot the figure

fs = 7; 
hp = 0.02; % horizontal padding
vp = 0.06; 
maxA = 10; 
maxph = 30; 
lw = 1; 
Aaxcol = .15*[1 1 1]; 
axcol = 0.15*[1 1 1]; 

col = cmocean('amp',5); 
Acol = col(4,:); 
col2 = cmocean('tempo',5); 
phcol = col2(4,:); 

figure('pos',[10   10   617 220])

subsubplot(2,5,1,'hpad',hp,'vpad',vp)
plot(ab.A_mad*1.4826,'linewidth',1,'color',Acol)
ylabel('Amplitude uncertainty (m yr^{-1})','FontSize',fs)
set(gca,'fontsize',fs,'xcolor',Aaxcol) 
axis([0 15.5 0 maxA])
box off
ntitle(' a ','fontweight','bold','fontsize',fs+1,'location','northwest')
set(gca,'xtick',1:2:15)

subsubplot(2,5,6,'hpad',hp,'vpad',vp)
plot(ab.ph_mad*1.4826,'linewidth',1,'color',phcol) 
ylabel 'Phase uncertainty (days)' 
xlabel 'Iterations'
set(gca,'fontsize',fs) 
axis([0 15.5 0 maxph])
box off
ntitle(' b ','fontweight','bold','fontsize',fs+1,'location','northwest')
set(gca,'xtick',1:2:15)

subsubplot(2,5,2,'hpad',hp,'vpad',vp)
plot(cd.un/1000,cd.A_mad*1.4826,'linewidth',1,'color',Acol)
set(gca,'fontsize',fs,'xcolor',Aaxcol,'ycolor',axcol) 
axis([0 max(cd.un/1000) 0 maxA]) 
ntitle(' c ','fontweight','bold','fontsize',fs+1,'location','northwest')
set(gca,'xtick',0:1:15)

subsubplot(2,5,7,'hpad',hp,'vpad',vp)
plot(cd.un/1000,cd.ph_mad*1.4826,'linewidth',1,'color',phcol) 
xlabel '{\itN} image pairs {\times}1000'
set(gca,'fontsize',fs,'ycolor',axcol) 
axis([0 max(cd.un/1000) 0 maxph]) 
ntitle(' d ','fontweight','bold','fontsize',fs+1,'location','northwest')
set(gca,'xtick',0:1:15)

subsubplot(2,5,3,'hpad',hp,'vpad',vp)
plot(ef.un,ef.A_mad*1.4826,'linewidth',1,'color',Acol)
axis tight
set(gca,'xscale','log','xcolor',Aaxcol,'ycolor',axcol)
axis([min(ef.un) max(ef.un)/10 0 maxA])
set(gca,'xtick',10.^(-1:5),'fontsize',fs) 
ntitle(' e ','fontweight','bold','fontsize',fs+1,'location','northwest')

subsubplot(2,5,8,'hpad',hp,'vpad',vp)
plot(ef.un,ef.ph_mad*1.4826,'linewidth',1,'color',phcol)
xlabel 'Interannual variablity (m yr^{-1})'
set(gca,'fontsize',fs) 
axis tight
set(gca,'xscale','log')
axis([min(ef.un) max(ef.un)/10 0 maxph])
set(gca,'xtick',10.^(-1:5),'ycolor',axcol)
ntitle(' f ','fontweight','bold','fontsize',fs+1,'location','northwest')

subsubplot(2,5,4,'hpad',hp,'vpad',vp)
plot(gh.un,gh.A_mad*1.4826,'linewidth',1,'color',Acol)
set(gca,'fontsize',fs,'xcolor',Aaxcol,'ycolor',axcol) 
axis([0 max(gh.un) 0 maxA]) 
ntitle(' g ','fontweight','bold','fontsize',fs+1,'location','northwest')
set(gca,'xtick',0:100:500)

subsubplot(2,5,9,'hpad',hp,'vpad',vp)
plot(gh.un,gh.ph_mad*1.4826,'linewidth',1,'color',phcol) 
xlabel 'Seasonal amplitude (m yr^{-1})'
set(gca,'fontsize',fs,'ycolor',axcol) 
axis([0 max(gh.un) 0 maxph]) 
ntitle(' h ','fontweight','bold','fontsize',fs+1,'location','northwest')
set(gca,'xtick',0:100:500)

subsubplot(2,5,5,'hpad',hp,'vpad',vp)
plot(ij.un,ij.A_mad*1.4826,'linewidth',1,'color',Acol)
set(gca,'fontsize',fs,'xcolor',Aaxcol,'ycolor',axcol) 
axis([0 max(ij.un) 0 maxA]) 
ntitle(' i ','fontweight','bold','fontsize',fs+1,'location','northwest')

subsubplot(2,5,10,'hpad',hp,'vpad',vp)
plot(ij.un,ij.ph_mad*1.4826,'linewidth',1,'color',phcol) 
xlabel 'Day of max velocity'
set(gca,'fontsize',fs,'ycolor',axcol) 
axis([0 max(ij.un) 0 maxph]) 
ntitle(' j ','fontweight','bold','fontsize',fs+1,'location','northwest')

% export_fig itslive_seasonal_parameters.png -r600 -painters


