% This script makes figure 3 of the Greene et al paper on methods
% to recover seasonal ice dynamics from ITS_LIVE data. 
% Let me know if you have any questions. chad@chadagreene.com
% Chad A. Greene, April 2020




%% Calculate statistics of itslive data

[c,x,y] = itslive_data('count');
c = double(c); 
v = itslive_data('v');
c(isnan(v)) = NaN; 

ind = c>100 & v>15; 
mean(c(ind),'omitnan')   % = 1605.4
median(c(ind),'omitnan') % = 1153

% Standard deviation (don't omit nan because I want only grid cells with all years of data
% This might take a minute or two...
[vs,x,y] = itslive_tilefun('v',2013:2018,@std,'tilesize',1500);

mean(vs(ind),'omitnan')  % = 10.06
median(vs(ind),'omitnan')% = 4.22

%% Make the figure

fs = 7; % fontsize 

figure('pos',[100 100 413 278])

subplot(3,4,[1,2,5,6])
imagescn(x,y,c)
axis image off
cb = colorbar('south');
set(gca,'colorscale','log')
cmocean dense
xlabel(cb,'{\it N} image pairs')
cb.Position = [0.14 0.50 0.15 0.01];
set(cb,'XAxisLocation','bottom','fontsize',fs)

set(cb,'fontsize',fs,'xtick',[1 10 100 1000 10000])
ntitle(' a','fontsize',8,'fontweight','bold','location','nw')

cm = cmocean('dense'); 
subplot(3,4,9) 
histogram(c(ind),logspace(2,log10(max(c(:))),100),'edgecolor','none','facecolor',cm(173,:),'facealpha',1)
axis tight 
box off
xlabel('{\it N} image pairs') 
set(gca,'xscale','log','xtick',[100 1000 10000 1000000],'fontsize',fs)
ylabel 'count'
h(1) = vline(1153,'--','color',rgb('dark red'));

ntitle(' c','fontsize',8,'fontweight','bold','location','nw')

%

subplot(3,4,[3,4,7,8])
imagescn(x,y,vs)
cb2 = colorbar('south'); 
xlabel(cb2,'interannual variability (m/yr)','fontsize',fs) 
set(gca,'colorscale','log','fontsize',fs) 
axis image off 

cb2.Position = [0.56 0.50 0.15 0.01];
ntitle(' b','fontsize',8,'fontweight','bold','location','nw')
set(cb2,'xtick',10.^(0:4))
set(cb2,'XAxisLocation','bottom')

cm = parula; 
subplot(3,4,10) 
histogram(vs(ind),logspace(-1.1,3,100),'edgecolor','none','facecolor',cm(63,:),'facealpha',1)
axis tight
box off
set(gca,'xscale','log','fontsize',fs,'xtick',[0.1 1 10 100 1000 10000])
h(2) = vline(4.22,'--','color',rgb('dark red'));
ylabel('count','fontsize',fs) 

xlabel({'interannual';'variability (m/yr)'})

ntitle(' d','fontsize',8,'fontweight','bold','location','nw')

%% 

load image_pair_times.mat
dt = diff(t,1,2)/365.25; 
derr = vx_err.*dt; 

median(derr) % = 4.89 m

cm = brewermap(2,'Dark2'); 

subplot(3,4,12) 
histogram(vx_err,logspace(log10(0.3),log10(1625),100),'facealpha',1,'edgecolor','none','facecolor',cm(2,:))

axis tight
set(gca,'xscale','log','fontsize',fs,'xtick',[1 10 100 1000 10000])
box off
ylabel count 

xlabel({'velocity error';'\sigma_v (m/yr)'})
ntitle(' f','fontsize',8,'fontweight','bold','location','nw')

subplot(3,4,11) 
histogram(derr,logspace(min(log10(0.1)),max(log10(371)),100),'facealpha',1,'edgecolor','none','facecolor',cm(1,:))
axis tight
set(gca,'xscale','log','fontsize',fs,'xtick',[0.1 1 10 100 1000 10000])
box off
ylabel count 
xlabel({'displacement error';'\sigma_d (m)'})
ntitle(' e','fontsize',8,'fontweight','bold','location','nw')

h(3) = vline(median(derr),'--','color',rgb('dark red')); 

% export_fig itslive_stats.png -r600 


