
% This script makes figure 2 of the Greene et al paper on methods
% to recover seasonal ice dynamics from ITS_LIVE data. 
% Let me know if you have any questions. chad@chadagreene.com
% Chad A. Greene, April 2020

%%

load image_pair_times.mat % taken from all of Antarctica as of Dec 2019. 

dt = diff(t,1,2);

% only look at same path row:
good = mod(dt,16)==0; % (approximately same path row. not exactly, but differences are negligible) 
dt = dt(good); 
t = t(good,:); 
vx_err = vx_err(good); 

%%

fs = 6; % fontsize 
col = brewermap(9,'set1'); % colormap 

figure('pos',[28 300 269 435]) 

subplot(3,1,1)
h1 = histogram([doy(t(:,1));doy(t(:,1))+365],1:2*366,'edgecolor','none','facecolor',col(3,:),'facealpha',0.5);
hold on
h2 = histogram([doy(t(:,2));doy(t(:,2))+365],1:2*366,'edgecolor','none','facecolor',col(1,:),'facealpha',0.5);
axis tight
box off
datetick('x','mmm')
set(gca,'xtick',datenum(0,1:2:36,1),'fontsize',fs)
datetick('x','mmm','keepticks')
axis tight
ylabel('Count','fontsize',fs) 
set(gca,'fontsize',fs)
ntitle(' a ','fontweight','bold','fontsize',fs+1,'location','northwest')

yl = ylim; 
text(300,max(yl),{'First';'image'},'horiz','right','vert','top','fontsize',fs,'color',h1.FaceColor)
text(425,max(yl),{'Second';'image'},'horiz','left','vert','top','fontsize',fs,'color',h2.FaceColor)

%%

subplot(3,1,2)
histogram(dt,0.5:545.5,'edgecolor','none','facecolor',col(2,:),'facealpha',0.8)
axis tight
xlabel('Image pair separation time (days)','fontsize',fs) 
ylabel('Count','fontsize',fs) 
box off 
set(gca,'fontsize',fs)
ntitle(' b ','fontweight','bold','fontsize',fs+1,'location','northwest')
pos = get(gca,'pos'); 
pos(2) = pos(2)+0.04;
set(gca,'pos',pos)

% export_fig itslive_imagepair_times_histogram.png -r600

%% This figure didn't get included in the paper. 

derr = dt.*vx_err./365.25;

figure('pos',[128 320 269 435]) 

subplot(3,1,1)
histogram(derr,-0.1:0.1:75,'edgecolor','none','facecolor',col(2,:),'facealpha',0.8)
box off
ylabel('count','fontsize',fs) 
xlabel('displacement error (m)','fontsize',fs)
set(gca,'fontsize',fs,'xtick',0:10:100)
axis tight

subplot(3,1,2)
histogram(vx_err,-0.1:0.1:75,'edgecolor','none','facecolor',col(4,:),'facealpha',0.8)
box off
ylabel('count','fontsize',fs) 
xlabel('velocity error (m/yr)','fontsize',fs)
set(gca,'fontsize',fs,'xtick',0:10:100)
axis tight

% export_fig itslive_error_histograms.png -r600


