
% This script makes figure 1 from Greene et al's paper on seasonal ice
% dynamic signal detection. Sorry it's not well commented. Just let me 
% know if you have any questions. chad@chadagreene.com. 
% Chad A. Greene, April 2020. 

%% Do the mathy bits:

rng('default') % resets random number generator for consistent results 

t = -1000:0.1:1000; 

x = 40 + 20*cosd(t); 
noise = filt1('lp',50*randn(size(t)),'fs',10,'fc',1/50); 

v = x+noise; 
d = cumsum(v/10); 

t0 = find(t>-300,1,'first'); 
t1 = find(t>-80,1,'first'); 
t2 = find(t>40,1,'first'); 
t3 = find(t>300,1,'first'); 

% measurement times
tm = [t(t0) t(t1); % pretty inelegant, I know.
   t(t0) t(t2); 
   t(t0) t(t3);
   t(t1) t(t2); 
   t(t1) t(t3); 
   t(t2) t(t3)];  

dm = [d(t0) d(t1); 
   d(t0) d(t2); 
   d(t0) d(t3);
   d(t1) d(t2); 
   d(t1) d(t3); 
   d(t2) d(t3)];  

vm = diff(dm,1,2)./diff(tm,1,2); 

d_err = abs(750+600*randn(size(vm)))
vm_err = d_err./diff(tm,1,2); 

ft = sinefit(mean(tm,2),vm,'terms',3,'weight',1./vm_err.^2); 

%% Plot cumulative displacement 
% (This plot didn't end up in the paper) 

ind = t>-350 & t<350; 

ft_d = sinefit(t(ind),d(ind),'terms',4); 

fs = 7; 

figure('pos',[10 10 294 210])

ax1 = subsubplot(2,1,1,'vpad',0.01);
hvel = plot(t(ind),v(ind));
axis tight
ylabel 'velocity'
set(gca,'ytick',[],'fontsize',fs) 
box off
hold on
[hdot,hbar,hv] = itslive_tsplot(tm,vm,vm_err,'datenum'); 
hvl1=vline(t([t0 t1 t2 t3]),':','color',rgb('light gray'));

h_truefit = plot(t(ind),20*cosd(t(ind))+40);
h_badfit = plot(t(ind),sineval(ft,t(ind)));
ntitle(' a ','fontsize',fs+1,'fontweight','bold','location','nw')

ax2 = subsubplot(2,1,2,'vpad',0.01); 
hd = plot(t(ind),d(ind)); 
axis tight
ylabel('cumulative displacement')
set(gca,'ytick',[],'yaxislocation','left','xtick',t([t0 t1 t2 t3])','xticklabel',{'t_1';'t_2';'t_3';'t_4'},'fontsize',fs) 
box off
hvl2 = vline(t([t0 t1 t2 t3]),':','color',rgb('light gray'));
hold on
hd_truefit = plot(t(ind),sineval(ft_d,t(ind))); 
ntitle(' b ','fontsize',fs+1,'fontweight','bold','location','nw')

%[hdot2,hbar2,hv2] = itslive_tsplot(tm,mean(dm,2),d_err,'datenum'); 
plot(tm,interp1(t,d,tm),'color',0.8*[1 1 1])

col = brewermap(9,'set1'); 
hvel.Color = col(2,:); 
hvel.LineWidth = 1;  
hd.LineWidth = hvel.LineWidth; 
hdot.Color = 0.2*[1 1 1]; 
set(hbar(:),'color', 0.8*[1 1 1]); 
set(hv(:),'color', 0.8*[1 1 1]); 
% hdot2.Color = 0.2*[1 1 1]; 
% set(hbar2(:),'color', 0.8*[1 1 1]); 
% set(hv2(:),'color', 0.8*[1 1 1]); 
h_truefit.Color = col(1,:); 
h_badfit.Color = 0.45*[1 1 1]; 
hd.Color = hvel.Color; 
hd_truefit.Color = h_truefit.Color; 

dh = 0.1; 
ax2.Position(4) = ax2.Position(4)-dh; 
ax1.Position(2) = ax1.Position(2)-dh; 
ax1.Position(4) = ax1.Position(4)+dh; 

%% Plot the figure 1 from the first submission: 

figure('pos',[10 10 294 210])

ax1 = subsubplot(2,1,2,'vpad',0.01);
hvel = plot(t(ind),v(ind));
axis tight
ylabel 'ice velocity'
set(gca,'ytick',[],'fontsize',fs) 
box off
hold on
[hdot,hbar,hv] = itslive_tsplot(tm,vm,vm_err,'datenum'); 

h_badfit = plot(t(ind),sineval(ft,t(ind)));

col = brewermap(9,'set1'); 
hvel.Color = col(2,:); 
hvel.LineWidth = 1;  
hdot.Color = 0.2*[1 1 1]; 
set(hbar(:),'color', 0.8*[1 1 1]); 
set(hv(:),'color', 0.8*[1 1 1]); 

h_badfit.Color = 0.45*[1 1 1]; 
set(gca,'ytick',[],'yaxislocation','left','xtick',t([t0 t1 t2 t3])','xticklabel',{'t_1';'t_2';'t_3';'t_4'},'fontsize',fs) 

yl = ylim;
ylim([yl(1)-0.03*range(yl) yl(2)+0.03*range(yl)])

hdot.MarkerSize = 0.1; 
set(hbar(:),'color', 0.8*[1 1 1],'LineWidth',0.5); 
set(hv(:),'color', 0.8*[1 1 1],'LineWidth',0.5); 

h_badfit.Color = 0.7*[1 1 1];
h_badfit.LineStyle = '--';
set(hbar(:),'Color',0.5*[1 1 1])
set(hv(:),'Color',0.5*[1 1 1])

col = brewermap(9,'paired');

hvel.Color = col(2,:);
h_badfit.Color=col(5,:);
h_badfit.LineStyle = ':';

hvel.LineWidth = 0.75;

% export_fig velocity_measurement_cartoon.png -r600 -painters

%% Plot the figure 1 from the revised manuscript: 

ind = t>-350 & t<350; 

ft_d = sinefit(t(ind),d(ind),'terms',4); 

fs = 7; 

figure('pos',[10 10 294 210])

ax1 = subsubplot(2,1,1,'vpad',0.01);
hvel = plot(t(ind),v(ind));
axis tight
ylabel 'ice velocity'
set(gca,'ytick',[],'fontsize',fs) 
box off
hold on
[hdot,hbar,hv] = itslive_tsplot(tm,vm,vm_err,'datenum'); 

h_badfit = plot(t(ind),sineval(ft,t(ind)));

col = brewermap(9,'set1'); 
hvel.Color = col(2,:); 
hvel.LineWidth = 1;  
hdot.Color = 0.2*[1 1 1]; 
set(hbar(:),'color', 0.8*[1 1 1]); 
set(hv(:),'color', 0.8*[1 1 1]); 

h_badfit.Color = 0.45*[1 1 1]; 
set(gca,'ytick',[],'yaxislocation','left','xtick',t([t0 t1 t2 t3])','xticklabel',{'t_1';'t_2';'t_3';'t_4'},'fontsize',fs) 

yl = ylim;
ylim([yl(1)-0.03*range(yl) yl(2)+0.03*range(yl)])

hdot.MarkerSize = 0.1; 
set(hbar(:),'color', 0.8*[1 1 1],'LineWidth',0.5); 
set(hv(:),'color', 0.8*[1 1 1],'LineWidth',0.5); 

h_badfit.Color = 0.7*[1 1 1];
h_badfit.LineStyle = ':';
set(hbar(:),'Color',0.5*[1 1 1])
set(hv(:),'Color',0.5*[1 1 1])

col = brewermap(9,'set1');

hvel.Color = col(2,:);
h_badfit.Color=col(5,:);

hvel.LineWidth = 0.75;
%ntitle(' a ','fontsize',fs+1,'fontweight','bold','location','nw')

%h_truefit = plot(t(ind),20*cosd(t(ind))+40);

h_badfit.Color = col(1,:);
h_truefit = plot(t(ind),20*cosd(t(ind))+40);
h_truefit.Color = col(1,:);
h_truefit.Color(4) = 0.3;
h_badfit.Color(4) = 0.5;

ax2 = subsubplot(2,1,2,'vpad',0.01); 

hd = plot(t(ind),d(ind)); 
axis tight
ylabel('cumulative displacement')
set(gca,'ytick',[],'yaxislocation','left','xtick',t([t0 t1 t2 t3])','xticklabel',{'t_1';'t_2';'t_3';'t_4'},'fontsize',fs) 
box off
hold on
hd_truefit = plot(t(ind),sineval(ft_d,t(ind))); 
%ntitle(' b ','fontsize',fs+1,'fontweight','bold','location','nw')

%[hdot2,hbar2,hv2] = itslive_tsplot(tm,mean(dm,2),d_err,'datenum'); 
pl=plot(tm,interp1(t,d,tm),'x','color',0.5*[1 1 1],'markersize',3);
% for k = 1:length(tm)
%    tmp=plot(tm(k,:),interp1(t,d,tm(k,:)),'color',0.5*[1 1 1]); 
%    uistack(tmp,'bottom')
% end

hd.Color = hvel.Color; 
hd_truefit.Color = col(1,:);
hd_truefit.Color(4) = 0.3;
uistack(hd_truefit,'bottom') % it's basically invisible this way, i know.

dh = 0.1; 
ax2.Position(4) = ax2.Position(4)-dh; 
ax1.Position(2) = ax1.Position(2)-dh; 
ax1.Position(4) = ax1.Position(4)+dh; 

% export_fig velocity_measurement_cartoon.png -r600 -painters
