


%% Load data

%load byrd_test_data 
load image_pair_times.mat
spr = mod(diff(t,1,2),16)==0; % same path row
t = t(spr,:); 
v_err = vx_err(spr); 
tm = mean(t,2); % mean times
dyr = diff(t,1,2)/365.25; 

% Sorry, y'all, these two contain the counts, but you can create them
% yourself like 
% c = itslive_data('count'); 
% v = itslive_data('velocity'); 
% c = c(c>100 & v>15); % counts for all grid cells of interest. 
% And similarly, use itslive_tilefun to get the standard deviation of 
% velocity for 2013-present. 
load itslive_counts.mat
load itslive_interannual_std.mat

clear spr vx_err

% trim to landsat 7+ epoch? 
if true
   keep = t(:,1)>datenum('april 15, 1999'); 
   t = t(keep,:); 
   v_err = v_err(keep); 
   tm = tm(keep); 
   dyr = dyr(keep); 
end

%%

% Which kind of test are we gonna run? 
% 'all' attempts to mimic distributions seen in Antarctica
% 'iter' tests number of requisite iterations (slow) 
% 'inter' is interannual variability
% 'npair' tests number of requisite image pairs. 
testcase = 'single'; % 'all', 'iter', 'npair', 'inter' 

switch testcase 
   case 'all' 
      N_tests = 50000; 
      c=c(c>=500); 
      N_pairs = c(randperm(length(c),N_tests)); % counts
      %N_pairs = 1153*ones([1 N_tests]); 
      interannual_rms = itslive_interannual_std(randperm(length(itslive_interannual_std),N_tests))'; 
      iterations = 1; % not actual iterations, just the number of times we're doing the test. It'll be 10 iterations.
      A = 100*rand(N_tests,1);
      ph = 365*rand(N_tests,1);
   case 'iter'
      N_tests = 10000; 
      iterations = 15; 
      N_pairs = 1153*ones([1 N_tests]); 
      interannual_rms = 4.2*ones(1,N_tests); 
      A = 100*rand(N_tests,1);
      ph = 365*rand(N_tests,1);
   case 'npair'
      N_tests = 100000; 
      N_pairs = repmat(round(10.^(linspace(1.5,4,25))),1,round(N_tests/25));
      interannual_rms = 4.2*ones(1,N_tests); 
      iterations = 1; % not actual iterations, just the number of times we're doing the test. It'll be 10 iterations.
      A = 100*rand(N_tests,1);
      ph = 365*rand(N_tests,1);
   case 'inter'
      N_tests = 100000; 
      N_pairs = 1153*ones([1 N_tests]); 
      interannual_rms = repmat(round(10.^(linspace(-2,3.4,25))),1,round(N_tests/25));
      iterations = 1; % not actual iterations, just the number of times we're doing the test. It'll be 10 iterations.
      A = 100*rand(N_tests,1);
      ph = 365*rand(N_tests,1);
   case 'A'
      N_tests = 50000; 
      N_pairs = 1153*ones([1 N_tests]); 
      iterations = 1; % not actual iterations, just the number of times we're doing the test. It'll be 10 iterations.
      interannual_rms = 4.2*ones(1,N_tests); 
      A = repmat([0 10.^(linspace(-1,2.7,24))]',round(N_tests/25),1);
      ph = 365*rand(N_tests,1);
   case 'phase'
      N_tests = 50000; 
      N_pairs = 1153*ones([1 N_tests]); 
      iterations = 1; % not actual iterations, just the number of times we're doing the test. It'll be 10 iterations.
      interannual_rms = 4.2*ones(1,N_tests); 
      A = 100*rand(N_tests,1);
      ph = repmat(linspace(0,365,25),1,round(N_tests/25))';
   case 'single' % special, specific cases
      N_tests = 5000; 
      N_pairs = 5189*ones([1 N_tests]); 
      interannual_rms = 3.85*ones(1,N_tests); 
      iterations = 1; % not actual iterations, just the number of times we're doing the test. It'll be 10 iterations.
      A = 12.4*rand(N_tests,1);
      %ph = 365*rand(N_tests,1);
      ph = (1+365/2)*ones(N_tests,1); 
      
   otherwise 
      error('Unrecognized testcase.')
end
      
% Preallocate measured amplitude and phase: 
Am = NaN(N_tests,iterations); 
phm = Am; 

var_resid = Am; 
err = Am; 

% Make a continuous daily array of known velocities: 
ti = ((min(t(:,1))-1):(max(t(:,2))+1))'; 

% Filtered random time series (plus an extra years worth on each end) for interannual variability: 
rf = filt1('lp',rand(length(ti)+365*3,N_tests)-0.5,'fs',365.25,'Tc',1.5,'order',1); 

% Scale the filtered random numbers to the desired rms (exclude first and last yr bc of filter edge effects) : 
rfA = rms(rf(548:end-548,:)); % amplitude of filtered random signal

vi_interannual = rf(548:end-548,:).*interannual_rms./rfA; 

for k = 1:N_tests
   
   % daily time series of "actual" velocity: 
   vi = vi_interannual(:,k) + sineval([A(k) ph(k)],ti) + 1000; % (m/yr)
   
   % daily displacement time series: 
   di = cumtrapz(ti/365.25,vi); % (m) 
   
   % Randomized measurement: 
   indk = randperm(length(v_err),N_pairs(k));
   t_tmp = t(indk,:); 
   v_err_tmp = v_err(indk); 
   dyr_tmp = dyr(indk); 
   
   d_noise = v_err(indk).*dyr(indk).*randn(N_pairs(k),1); 
   d_measured = diff(interp1(ti,di,t_tmp),1,2) + d_noise; 
   v_measured = d_measured./dyr(indk); 
   
   if strcmpi(testcase,'iter')
      for ik = 1:iterations
         [Am(k,ik),phm(k,ik)] = itslive_seasonal(t_tmp,v_measured,v_err_tmp,'iter',ik); 
      end
   else
      [Am(k),phm(k),var_resid(k),err(k)] = itslive_seasonal(t_tmp,v_measured,v_err_tmp); 
   end

   if mod(k,100)==0
      k % just prints the loop number to show progress. 
   end
end

% Differences from truth: 
phd = phase_diff(ph,phm); 
Ad = Am - A; 

return 


%%

np = 100:100:10000; 
Aerr = NaN(size(np)); 
pherr = Aerr; 
for k = 1:length(np)
   ind = N_pairs>=np(k); 
   Aerr(k)= 1.4826*median(abs(Ad(ind))); 
   pherr(k)= 1.4826*median(abs(phd(ind))); 
end
   
figure
plot(np,Aerr,'r')
hold on
plot(np,pherr,'color',rgb('green'))

%% Iterations

A_mad = median(abs(Ad),'omitnan'); 
ph_mad= median(abs(phd),'omitnan'); % sigma is 1.4826*mad

fs = 7; 

figure('pos',[10 10 278 200])

pl(1) = plot(A_mad*1.4826);
txt(1) = text(iterations,A_mad(end)*1.4826,'Amplitude error (m/yr)','color',pl(1).Color,'horiz','right','vert','top','fontsize',fs);
hold on
pl(2) = plot(ph_mad*1.4826);
txt(2) = text(iterations,ph_mad(end)*1.4826,'Phase error (days)','color',pl(2).Color,'horiz','right','vert','top','fontsize',fs);
axis tight
box off 
yl = ylim; 
ylim([0 yl(2)])
xlabel 'Iterations' 
set(gca,'fontsize',fs,'xtick',1:iterations)

readme = 'iter test from itslive_seasonal_UQ2.m with A random from 0 to 100.'; 
% export_fig itslive_seasonal_iter.png -r600
% save('itslive_seasonal_iter.mat','A_mad','ph_mad','N_tests','readme')

plot(median(abs(Ad2),'omitnan')*1.4826,'k')
plot(median(abs(phd2),'omitnan')*1.4826,'k')

%%


figure
subplot(2,1,1) 
plot(err,abs(Ad),'.') 

subplot(2,1,2) 
plot(var_resid,abs(Ad),'.') 

%% portrait 

iter = 1;
sc = 1; 
fs = 7;
phasecolorbar = false; 

figure('pos',[100 200 308 470])

subplot(2,1,1)
plot([0 max(A)],[0 max(A)],'color',rgb('gray')) 
hold on
if phasecolorbar
   scatter(A,Am(:,iter),sc,ph,'filled') 
   cmocean phase
   caxis([1 365.25])
   cb = colorbar; 
   ylabel(cb,'imposed time of maximum velocity')
   set(cb,'ytick',15:30.4:366,'fontsize',fs,'ydir','reverse')
   cbdate('mmm')
else
   scatter3(A,Am(:,iter),1./interannual_rms,sc,interannual_rms,'filled') 
   cmocean -amp
   cb1 = colorbar; 
   ylabel(cb1,'interannual variability (m/yr)')
   set(cb1,'fontsize',fs)
   caxis([0.5 100])
   set(gca,'colorscale','log')
end
axis equal
axis([0 ceil(max(A)) 0 ceil(max(A))])
xlabel 'imposed seasonal amplitude (m/yr)'
ylabel 'recovered seasonal amplitude (m/yr)'
box off
set(gca,'fontsize',fs,'xtick',0:10:100,'ytick',0:10:100)
   
subplot(2,1,2)
plot([0 365],[0 365],'color',rgb('gray')) 
hold on
scatter3(ph,phm(:,iter),A,sc,A,'filled') 
axis equal
axis([0 365 0 365])
cmocean tempo 
cb = colorbar; 
ylabel(cb,'imposed seasonal amplitude (m/yr)','fontsize',fs)
ylabel 'recovered time of maximum velocity'
xlabel 'imposed time of maximum velocity'
box off
set(gca,'fontsize',fs)
set(gca,'xtick',15:30.4:366,'ytick',15:30.4:366);
datetick('x','mmm','keeplimits','keepticks')

datetick('y','mmm','keeplimits','keepticks')

% export_fig recovered_amp_phase_all_4.png -r600
%save('recovered_amp_phase_all_4.mat','A','Am','interannual_rms','ph','phm','readme') 
return

%% Npair 

cmA = cmocean('amp',9); 
cmph = cmocean('tempo',9); 
kA = 8; 

fs=7; 

un = unique(N_pairs); 
for k = 1:length(un)
   ind = N_pairs==un(k); 
   A_mad(k) = median(abs(Ad(ind)),'omitnan'); 
   ph_mad(k) = median(abs(phd(ind)),'omitnan'); 
end

figure('pos',[100 200 308 300])
pl(1) = plot(un,ph_mad*1.4826)
hold on
pl(2) = plot(un,A_mad*1.4826)
hold on 
axis tight
%if kA==1
   txt(1) = text(un(end),ph_mad(end)*1.4826,'Phase error (days)','color',pl(1).Color,'horiz','right','vert','bot','fontsize',fs);
   txt(2) = text(un(end),A_mad(end)*1.4826,'Amplitude error (m/yr)','color',pl(2).Color,'horiz','right','vert','bot','fontsize',fs);
%end
box off
yl = ylim; 
ylim([0 15])
xlabel 'N image pairs'
ylabel('1\sigma uncertainty')

% export_fig itslive_seasonal_Npairs.png -r600
readme = 'created by itslive_seasonal_UQ_2.m';
%save('itslive_seasonal_Npairs.mat','A_mad','ph_mad','un','N_tests','readme')

%% Interannual rms 

fs=7; 

un = unique(interannual_rms); 
for k = 1:length(un)
   ind = interannual_rms==un(k); 
   A_mad(k) = median(abs(Ad(ind)),'omitnan'); 
   ph_mad(k) = median(abs(phd(ind)),'omitnan'); 
end

figure('pos',[100 200 308 300])
pl(1) = plot(un,A_mad*1.4826);
hold on
pl(2) = plot(un,ph_mad*1.4826); 
axis tight
txt(1) = text(un(end),A_mad(end)*1.4826,'Amplitude error (m/yr)','color',pl(1).Color,'horiz','right','vert','top','fontsize',fs);
txt(2) = text(un(end),ph_mad(end)*1.4826,'Phase error (days)','color',pl(2).Color,'horiz','right','vert','top','fontsize',fs);
box off 
yl = ylim; 
ylim([0 yl(2)])
xlabel 'interannual variability'

readme = 'by itslive_seasonal_UQ_2, did 10k tests at A=0:25:100, then did 100k test for A=100*rand';

%save('itslive_seasonal_interannual.mat','A_mad','ph_mad','un')

%%

A = [0:100]; 
cm1 = cmocean('amp',length(A)); 
cm2 = cmocean('tempo',length(A)); 
hold on
for k=1:length(A) 
   [A_tmp,ph_tmp] = itslive_seasonal_unc(1153,0:2500,A(k)); 
   h_A(k) = plot(0:2500,A_tmp,'color',cm1(k,:)); 
   h_ph(k) = plot(0:2500,ph_tmp,'color',cm2(k,:)); 
end
   

pl(1) = plot(un,A_mad*1.4826,'color',cmocean('amp',1),'linewidth',2);
hold on
pl(2) = plot(un,ph_mad*1.4826,'color',cmocean('tempo',1),'linewidth',2); 
xlabel 'interannual variability (m/yr)' 
ylabel('1\sigma uncertainty \color[rgb]{0.08,0.11,0.26} (phase days) \color[rgb]{0.24,0.04,0.07} (amplitude m/yr)')

%% A seasonal variability

fs=7; 

un = unique(A); 
for k = 1:length(un)
   ind = A==un(k); 
   A_mad(k) = median(abs(Ad(ind)),'omitnan'); 
   ph_mad(k) = median(abs(phd(ind)),'omitnan'); 
end

figure('pos',[100 200 308 300])

pl(1) = plot(un,ph_mad*1.4826); 
hold on
pl(2) = plot(un,A_mad*1.4826);
hold on
axis tight
txt(1) = text(un(end),ph_mad(end)*1.4826,'Phase error (days)','color',pl(1).Color,'horiz','right','vert','bot','fontsize',fs);
txt(2) = text(un(end),A_mad(end)*1.4826,'Amplitude error (m/yr)','color',pl(2).Color,'horiz','right','vert','bot','fontsize',fs);
box off 
yl = ylim; 
ylim([0 45])
xlabel 'seasonal amplitude (m/yr)'
ylabel('1\sigma uncertainty') 

% export_fig itslive_seasonal_A.png -r600 
%save('itslive_seasonal_A.mat','A_mad','ph_mad','un')

%% phase seasonal variability

fs=7; 

un = unique(ph); 
for k = 1:length(un)
   ind = ph==un(k); 
   A_mad(k) = median(abs(Ad(ind)),'omitnan'); 
   ph_mad(k) = median(abs(phd(ind)),'omitnan'); 
end

figure('pos',[100 200 308 300])

pl(1) = plot(un,ph_mad*1.4826); 
hold on
pl(2) = plot(un,A_mad*1.4826);
hold on
axis tight
txt(1) = text(un(end),ph_mad(end)*1.4826,'Phase error (days)','color',pl(1).Color,'horiz','right','vert','bot','fontsize',fs);
txt(2) = text(un(end),A_mad(end)*1.4826,'Amplitude error (m/yr)','color',pl(2).Color,'horiz','right','vert','bot','fontsize',fs);
box off 
yl = ylim; 
ylim([0 45])
xlabel 'day of maximum velocity'
ylabel('1\sigma uncertainty') 

% export_fig itslive_seasonal_phase.png -r600 
%save('itslive_seasonal_phase.mat','A_mad','ph_mad','un')
