'''Main driver routine for induced surface flux field calculation'''

import isf

model = 'HadGEM3_GC3.1'
experiment = 'Hist1'
freq = 'monthly'
startyear = 1980
endyear = 1999
region_list = ['Arctic_Ocean.1','Arctic_Ocean.0']
threshold=271.15
gridname = 'eorca1'

for process in ['']:
    for obs_scheme in isf.obs_schemes():
        isflux = isf.InducedSurfaceFlux(model,experiment,freq,process,obs_scheme,threshold,gridname)
        isflux.get_obs_data()

        for year in range(startyear,endyear+1):
            print year
            isflux.get_model_data(year)
            isflux.generate_missing_data_mask(year)
            isflux.make_reference_states(year)
            isflux.make_process_anomaly(year)
            isflux.evaluate_pd(year)
            isflux.evaluate_flux_contribution(year)

        isflux.calc_ts(region_list)
        isflux.save()
