'''Calculates corrected ice thickness contribution as described in Appendix A'''

import isf
import attribution_constants as ac
import copy

model = 'HadGEM2_ES'
experiment = 'Hist4'
freq = 'monthly'
startyear = 1980
endyear = 1999
region_list = ['Arctic_Ocean.1','Arctic_Ocean.0']
threshold=271.15
gridname = 'hadgom'

for obs_scheme in isf.obs_schemes():
    for cat in range(1,6):
        process = 'Ice_thickness.cat.' + str(cat)
        isflux = isf.InducedSurfaceFlux(model,experiment,freq,process,obs_scheme,threshold,gridname)       
        isflux.get_obs_data()
        isflux.cvnames.append('Snow_thickness')
        isflux.model_datadirs['Snow_thickness'] = \
                '/data/local/hadax/PhD/Attribution/'+\
                isflux.model + '/' + isflux.experiment + '/' + isflux.freq + '/' +\
                isflux.gridname + '/Snow_thickness/'
        isflux.model_cubes['Snow_thickness'] = {}
        isflux.reference_cubes['Snow_thickness'] = {}

        for year in range(startyear,endyear+1):
            print year
            isflux.get_model_data(year)
            isflux.generate_missing_data_mask(year)
            isflux.make_reference_states(year)
            isflux.make_process_anomaly(year)

            cube_data = isflux.obs_cubes['Ice_thickness.cat.'+str(cat)]
            cube_cfg = copy.deepcopy(isflux.reference_cubes['Snow_thickness'][year])
            cube_cfg.data = cube_data.data

            add_expr = '* ((in_cube_list[0]/ac.kice + self.reference_cubes[\'Snow_thickness\']['+str(year)+']/ac.ksno)*self.reference_cubes[\'B_lw_dep\']['+str(year)+']*-1.+1.)**-1.'
            pd_expr = isflux.pd_expression(year)
            new_expr = pd_expr.replace('** 2.',add_expr)
            pd_alt = isflux.evaluate_expr(new_expr,[cube_cfg])
            isflux.partial_derivative[year] = pd_alt
            isflux.apply_mask(isflux.partial_derivative[year],year)

            isflux.evaluate_flux_contribution(year)

        isflux.calc_ts(region_list)
        isflux.process = 'Ice_thickness.complex.cat.'+str(cat)
        isflux.save()
