'''Combines category ice thickness induced surface flux biases into an aggregated ice thickness contribution'''

import iris
import numpy as np

model = 'HadGEM2_ES'
experiment = 'Hist4'
tprof = 'monthly'
gridname = 'hadgom'
startyear = 1980
endyear = 1999

import isf
version = isf.version

basedir = '/data/local/hadax/PhD/Attribution/'
datadir = basedir + 'output_' + version + '/output_3D/' + \
    model + '/' + experiment + '/' + tprof + '/' + gridname + '/'

for obs_scheme in isf.obs_schemes():
    print obs_scheme
    for year in range(startyear,endyear+1):
        print year
        cubelist = iris.cube.CubeList([])
        for cat in range(1,6):
            procname = 'Ice_thickness.complex.cat.'+str(cat)
            filename = procname + '.' + obs_scheme + '.' + str(year) + '.nc'
            ffile = datadir + filename
            ccube = iris.load_cube(ffile)
            pl_coord = iris.coords.AuxCoord(cat,long_name='pseudo_level')
            ccube.add_aux_coord(pl_coord)
            cubelist.append(ccube)

        all_cubelist = cubelist.merge()
        if len(all_cubelist) > 1:
            print 'Unable to merge cubes'
            raise ValueError

        all_cube = all_cubelist[0]
        sum_cube = all_cube.collapsed(['pseudo_level'],iris.analysis.SUM)
        outproc = 'Ice_thickness.complex'
        outfilename = outproc + '.' + obs_scheme + '.' + str(year) + '.nc'
        outfile = datadir + outfilename
        iris.save(sum_cube,outfile)


datadir = basedir + 'output_' + version + '/output_1D/' + \
    model + '/' + experiment + '/' + tprof + '/' + gridname + '/'

region_names = ['Arctic_Ocean.0','Arctic_Ocean.1']
for obs_scheme in isf.obs_schemes():
    for region_name in region_names:
        print obs_scheme
        cubelist = iris.cube.CubeList([])
        for cat in range(1,6):
            procname = 'Ice_thickness.complex.cat.'+str(cat)
            filename = procname + '.' + obs_scheme + '.' + str(endyear) + \
                '.' + region_name + '.nc'
            ffile = datadir + filename
            ccube = iris.load_cube(ffile)
            pl_coord = iris.coords.AuxCoord(cat,long_name='pseudo_level')
            ccube.add_aux_coord(pl_coord)
            cubelist.append(ccube)

        all_cubelist = cubelist.merge()
        if len(all_cubelist) > 1:
            print 'Unable to merge cubes'
            raise ValueError

        all_cube = all_cubelist[0]
        sum_cube = all_cube.collapsed(['pseudo_level'],iris.analysis.SUM)
        outproc = 'Ice_thickness.complex'
        outfilename = outproc + '.' + obs_scheme + '.' + str(year) + '.' + \
            region_name + '.nc'
        outfile = datadir + outfilename
        iris.save(sum_cube,outfile)


