import iris
import numpy as np
import timemod
import iris.coord_categorisation as icc
import datetime as dt

model = 'HadGEM2_ES'
experiments = ['Hist' + str(em) for em in range(1,5)]
tprof = 'monthly'
gridname = 'hadgom'
startyear = 1980
endyear = 1999
region_name = 'Arctic_Ocean.0'
version = 'v4_06_09_2018'
obs_name = 'CERES'
cf_obs_name = 'ERAI'

obs_scheme = 'std_'+obs_name

varnames_read = ['SW_down','LW_down','Ice_area','iimelt','Ice_thickness']
varnames_write = ['SW_down','LW_down','Ice_area','iimelt','Ice_thickness']

savedir = '/data/cr1/hadax/PhD/Papers/Dec2013_HadGEM2_energy_budget/v2.3/'
basedir = '/data/local/hadax/PhD/Attribution/'
datadirs = [basedir + 'output_'+version + '/' + 'output_1D/' + \
    model + '/' + experiment + '/' + tprof + '/' + gridname + '/' \
    for experiment in experiments]
savefile = savedir + 'Table1.isf.'+region_name+'.'+version+'.'+obs_scheme+'.dat'
ra_file = savedir + 'radiative_anom.'+obs_name + '.' + region_name + '.nc'
cf_ra_file = savedir + 'radiative_anom.'+cf_obs_name + '.' + region_name + '.nc'

ra_cube = iris.load_cube(ra_file)
radiative_anom = ra_cube.data
cf_ra_cube = iris.load_cube(cf_ra_file)
cf_radiative_anom = cf_ra_cube.data

all_data = {}
stds = {}
for var in varnames_read:
    cubelist = iris.cube.CubeList([])
    for (iexpt,datadir) in enumerate(datadirs):
        rcoord = iris.coords.AuxCoord(iexpt,'realization')
        filename = var + '.' + obs_scheme + '.' + str(endyear) + '.' + \
            region_name + '.nc'
        ffile = datadir + filename
        cube = iris.load_cube(ffile)
        cube.add_aux_coord(rcoord)
        cubelist.append(cube)

    ecubes = cubelist.merge()
    if len(ecubes) > 1:
        print 'Unable to merge ensemble cubes'
        raise ValueError

    ecube = ecubes[0]
    icc.add_month(ecube,'time')
    ddata = ecube.data
    ddata3 = np.reshape(ddata,(4,20,12))
    datastd = np.std(ddata3,axis=(0,1))
    stds[var] = datastd

    emcube = ecube.collapsed(['realization'],iris.analysis.MEAN)

    sc_cube = emcube.aggregated_by('month',iris.analysis.MEAN)
    sc_data = timemod.sc_for_plotting(sc_cube)

    all_data[var] = sc_data


total_isf = np.zeros(12)
for var in varnames_write:
    total_isf = total_isf + all_data[var]

isf_residual = total_isf - radiative_anom
obs_diff = radiative_anom - cf_radiative_anom

fileh = open(savefile,'w')
fileh.write(('{:15s} '*10+'\n').format('Month','Total','Rad. anomaly','ISF residual','Obs diff',*varnames_write))

for month in range(1,13):
    month_name = dt.date(1980,month,1).strftime('%b')

    data = [all_data[var][month-1] for var in varnames_write]
    fileh.write(('{:15s} '+'{:15.1f} '*9+'\n').format(month_name,total_isf[month-1],radiative_anom[month-1],isf_residual[month-1],obs_diff[month-1],*data))
    
fileh.close()
