def region(region_code,grid=None):
    import glob
    import iris

    if type(grid)==type(None):
        print 'Must specify grid name'
        return None

    region_dir = '/data/cr1/hadax/PP_masks/All/'
    region_file = glob.glob(region_dir + region_code + '.' + grid + '.??')[0]
    region_cube = iris.load_cube(region_file)
    return region_cube
    
  
def reduce_to_region(in_cube,region_code,grid,extract_inds=None):
    import iris
    import numpy.ma as ma   
    import numpy as np 
    import glob
    
    region_dir = '/data/cr1/hadax/PP_masks/All/'
    region_file = glob.glob(region_dir + region_code + '.' + grid+'.??')
    region_cube = iris.load_cube(region_file[0])
    
    if len(in_cube.shape) == 2:
        mask = region_cube.data.mask
        if not extract_inds is None:
            mask = mask[extract_inds[0][0]:extract_inds[0][1],\
                        extract_inds[1][0]:extract_inds[1][1]]
    elif len(in_cube.shape) >= 3:
        dd = in_cube._dim_coords_and_dims
        dim_names = [dim[0].standard_name for dim in dd]
        ad = in_cube._aux_coords_and_dims
        adim_names = [dim[0].standard_name for dim in ad]
        if 'latitude' in dim_names and 'longitude' in dim_names:
            latplace = dd[dim_names.index('latitude')][1]
            lonplace = dd[dim_names.index('longitude')][1]
        elif 'latitude' in adim_names and 'longitude' in adim_names:
            latplace = ad[adim_names.index('latitude')][1][0]
            lonplace = ad[adim_names.index('latitude')][1][1]
        else:
            print 'Can''t find latitude and longitude'
            return 0
        
        mask_tile = list(in_cube.shape)
        mask_tile[latplace] = 1
        mask_tile[lonplace] = 1
        mask = np.tile(region_cube.data.mask,mask_tile)
        if not extract_inds is None:
            mask = mask[:,extract_inds[0][0]:extract_inds[0][1],\
                        extract_inds[1][0]:extract_inds[1][1]]

    in_cube.data = ma.masked_array(in_cube.data,mask = mask)
    


def regrid_region(in_cube,out_grid,radius_minimum = 2.,old_area_weights=None,new_area_weights=None,quiet=True):
    import iris.analysis.cartography
    import iris.analysis
    import copy
    import numpy as np
    import field_functions as ff
    import regrid

    in_cube_ind = copy.deepcopy(in_cube)
    in_cube_ind.data = 1. * (in_cube_ind.data.mask == False)
    new_cube = regrid.regrid2(in_cube_ind,out_grid,radius_minimum = radius_minimum,quiet=quiet)
    masked_array = new_cube.data
    masked_index = np.where(masked_array.mask == True)
    nan_index = np.where(np.isnan(masked_array.data))
    new_cube.data = masked_array.data
    new_cube.data[masked_index[0],masked_index[1]] = 0.
    new_cube.data[nan_index[0],nan_index[1]] = 0.
    
    if not in_cube_ind.coord('latitude').has_bounds():
        in_cube_ind.coord('latitude').guess_bounds()
    
    if not in_cube_ind.coord('longitude').has_bounds():
        in_cube_ind.coord('longitude').guess_bounds()

    in_cube_ind.coord('longitude').units = 'degrees'
    in_cube_ind.coord('latitude').units = 'degrees'

    if type(old_area_weights) == type(None):
        old_area_weights = iris.analysis.cartography.area_weights(in_cube_ind)

    old_area = in_cube_ind.collapsed(['latitude','longitude'],iris.analysis.SUM,weights=old_area_weights)
    
    if type(new_area_weights) == type(None):
        if new_cube.coord('latitude').points.ndim == 1:
            if not new_cube.coord('latitude').has_bounds():
                new_cube.coord('latitude').guess_bounds()

            if not new_cube.coord('longitude').has_bounds():
                new_cube.coord('longitude').guess_bounds()
            new_area_weights = iris.analysis.cartography.area_weights(new_cube)
        else:
            new_area_weights = ff.area_weights(out_grid+'_estimate')

    ncdata_1D = copy.copy(new_cube.data)
    ncdata_1D = np.reshape(ncdata_1D,ncdata_1D.size)
    
    weights_1D = np.reshape(new_area_weights,ncdata_1D.size)

    indices = np.argsort(ncdata_1D)[::-1]
    weights_reorder = weights_1D[indices]
    weights_integrate = np.cumsum(weights_reorder)
    weights_anomaly = np.abs(weights_integrate - old_area.data)
    closest = np.argmin(weights_anomaly)
    
    ncdata_1D[indices[0:closest]] = 1.
    ncdata_1D[indices[closest:-1]] = 0.
    
    ncdata_new = np.reshape(ncdata_1D,new_cube.shape)
    new_cube.data = ncdata_new

    return new_cube


def exists_region(region_name,gridname):
    import glob
    datadir = '/data/cr1/hadax/PP_masks/All/'
    filepath = glob.glob(datadir + region_name + '.' + gridname + '.??')
    return (len(filepath) > 0)


