'''Computes useful variables for the surface flux approximation formulae, such as surface albedo, f_{atmos_ice} etc'''

model = 'HadGEM2_ES'
experiment = 'Hist4'
freq = 'monthly'
gridname = 'hadgom'
startyear = 1980
endyear = 1999

version = 'v4_06_09_2018'
basedir = '/data/local/hadax/PhD/Attribution/'

vars_in = ['LW_down','TTsfc','Sensible_heat_flux_over_ice','SW_down',\
    'Sensible_heat_flux_over_ocean','Latent_heat_flux_over_ocean',\
    'l_snow.0.01','iimelt']
vars_out = ['ice_albedo','f_atmos_ice','f_atmos_ocean']
sb_const = 5.67e-8

import iris
import os
import copy
import sys
sys.path.insert(0,version)
import attribution_constants as ac

datadir = basedir + model + '/' + experiment + '/' + freq + '/' + gridname + '/'

for year in range(startyear,endyear+1):
    print year
    cubedic = {}
    for var in vars_in:
        ffile = datadir + var + '/' + str(year) + '.nc'
        ccube = iris.load_cube(ffile)
        ccube.units = '1'
        cubedic[var] = ccube

    for var in vars_in[1:]:
        data = cubedic[var].data
        cubedic[var] = copy.deepcopy(cubedic[vars_in[0]])
        cubedic[var].data = data

    cubedic['ice_albedo'] = cubedic['l_snow.0.01'] * (ac.alpha_cs + \
                      cubedic['iimelt'] * (ac.alpha_s - ac.alpha_cs)) + \
                     (cubedic['l_snow.0.01']*-1.+1.) * (ac.alpha_ci + \
                      cubedic['iimelt'] * (ac.alpha_i - ac.alpha_ci))

    cubedic['f_atmos_ice'] = cubedic['LW_down'] - \
                  cubedic['TTsfc'] ** 4. * ac.emis_ice * sb_const + \
                  cubedic['Sensible_heat_flux_over_ice'] + \
                  cubedic['SW_down'] * (cubedic['ice_albedo'] * -1. + 1.)

    cubedic['f_atmos_ocean'] = cubedic['LW_down'] - \
                    ac.Tbot ** 4. * ac.emis_ocn * sb_const + \
                    cubedic['Sensible_heat_flux_over_ocean'] + \
                    cubedic['Latent_heat_flux_over_ocean'] + \
                    cubedic['SW_down'] * (cubedic['ice_albedo'] * -1. + 1.)

    for var in vars_out:
        if not os.path.exists(datadir + var + '/'):
            os.makedirs(datadir + var + '/')
        ffile = datadir + var + '/' + str(year) + '.nc'
        iris.save(cubedic[var],ffile)
