import iris
import numpy as np
import matplotlib.pyplot as plt
import glob
import regions
import cube_magic as cm
import datetime as dt
import copy
import iris.coord_categorisation as icc
from arrays import wrap
import sys
sys.path.insert(0,'/home/h01/hadax/Python/PhD/Obs/')
import cl_modis
from matplotlib.font_manager import FontProperties
import numpy.ma as ma
import sheba
import pylab
import timemod

outfile_eps = '/home/h01/hadax/graphics/PhD/Papers/'+\
    'Dec2013_HadGEM2_energy_budget/v2.3_figs/F8_winter_cloud_bias.eps'
outfile_png = '/home/h01/hadax/graphics/PhD/Papers/'+\
    'Dec2013_HadGEM2_energy_budget/v2.3_figs/F8_winter_cloud_bias.png'
font_use = FontProperties()
font_use.set_size(14)

region_name_cloudprops = 'Arctic_Ocean.1'
region_name_lwdown = 'SHEBA.0'
model_startyear = 1980
model_endyear = 1999
years = np.arange(model_startyear,model_endyear+1)
n_years = model_endyear - model_startyear + 1

model_ice_file = '/project/champ/data/cmip5/output1/MOHC/HadGEM2-ES/'+\
                 'historical/mon/atmos/Amon/r1i1p1/v20120928/clivi/'+\
                 'clivi_Amon_HadGEM2-ES_historical_r1i1p1_198012-200511.nc'
model_total_file = '/project/champ/data/cmip5/output1/MOHC/HadGEM2-ES/'+\
                 'historical/mon/atmos/Amon/r1i1p1/v20120928/clwvi/'+\
                 'clwvi_Amon_HadGEM2-ES_historical_r1i1p1_198012-200511.nc'

model_ice_cube = iris.load_cube(model_ice_file)
model_total_cube = iris.load_cube(model_total_file)

model_ice_cube = timemod.reduce(model_ice_cube,startyear=model_startyear,\
    endyear = model_endyear)
model_total_cube = timemod.reduce(model_total_cube,startyear=model_startyear,\
    endyear = model_endyear)

bins = np.arange(0,1.01,.1)
colours = ['#ff0000','#ff0000','#ff0060','#6000ff','#0000ff']

regions.reduce_to_region(model_ice_cube,region_name_cloudprops,'n96')
regions.reduce_to_region(model_total_cube,region_name_cloudprops,'n96')
ice_ratio = model_ice_cube / model_total_cube

histogram = np.zeros((12,len(bins)-1))
for nbin in range(len(bins)-1):
    lower = bins[nbin]
    upper = bins[nbin+1]
    
    ice_logical = np.logical_and(ice_ratio.data >= lower,\
                                 ice_ratio.data <  upper).astype('float')
    ice_logical_cube = iris.cube.Cube(ice_logical)
    ice_logical_cube.add_dim_coord(ice_ratio.coord('time'),0)
    ice_logical_cube.add_dim_coord(ice_ratio.coord('latitude'),1)
    ice_logical_cube.add_dim_coord(ice_ratio.coord('longitude'),2)
    icc.add_month(ice_logical_cube,'time')
    
    for month in range(1,13):
        month_name = dt.date(1980,month,1).strftime('%b')
        index = np.where(ice_logical_cube.coord('month').points == month_name)

        bin_subcube = ice_logical_cube[index[0],:,:]
        ref_subcube = copy.deepcopy(bin_subcube)
        ref_subcube.data.data[:] = 1.
        cm.llbounds(bin_subcube)
        aw = iris.analysis.cartography.area_weights(bin_subcube)

        area_bin = bin_subcube.collapsed(['latitude','longitude'],\
                        iris.analysis.SUM, weights = aw)
        area_ref = ref_subcube.collapsed(['latitude','longitude'],\
                        iris.analysis.SUM, weights = aw)

        ratio = np.mean(area_bin.data / area_ref.data)
        histogram.itemset((month-1,nbin), ratio)

modis_histogram = cl_modis.find_ice_ratio(bins=bins,\
    region_name=region_name_cloudprops)
modis_mhistogram = ma.masked_array(modis_histogram, mask = np.isnan(\
                                                   modis_histogram))


n_ens = 3
runids = ['ajhoh','ajkkg','ajkkh','ajgsi']
varname = 'surface_net_downward_longwave_flux'

month_names = ['nov','dec','jan','feb','mar']

all_values = []
all_cubelist = iris.cube.CubeList([])

values_dics = [{}] * n_ens
for ensemble_member in range(1,n_ens+1):
    datadir = '/data/local/hadax/HadGEM2_ES_Hist'+str(ensemble_member)+\
        '/SFC_t_hires/'
    for mn in month_names:
        print 'Reading in data for '+mn
        files = glob.glob(datadir+runids[ensemble_member-1]+'a.pi*'+mn+'.pp')

        cube = iris.load_cube(files,varname)

        regions.reduce_to_region(cube,region_name_lwdown,'n96')
        cm.llbounds(cube)
        aw = iris.analysis.cartography.area_weights(cube)

        icc.add_year(cube,'time')
        for year in years:
            year_cube = cube.extract(iris.Constraint(year=year))

            region_index = np.where(year_cube.data.mask == False)
    
            values = year_cube.data[region_index]

            if year in values_dics[ensemble_member-2].keys():
                values_dics[ensemble_member-1][year] = np.concatenate((values,values_dics[ensemble_member-1][year]))
            else:
                values_dics[ensemble_member-1][year] = values

    #all_cubelist.append(ts_cube)

# Get SHEBA values
dd = sheba.dataset()
LWu = dd.variables['LWu'][:]
LWd = dd.variables['LWd'][:]
Jdd = dd.variables['Jdd'][:]
datetimes = sheba.convert_Jdd_to_datetime(Jdd)
dt_log = [dt.month not in [12,1,2,3] for dt in datetimes]

mask_LWu = sheba.mask(LWu)
mask_LWd = sheba.mask(LWd)

mask_LWn = mask_LWd - mask_LWu
SHEBA_LWn = ma.masked_array(mask_LWn,mask=dt_log)
SHEBA_LWn = SHEBA_LWn.data[np.where(SHEBA_LWn.mask == False)]

lw_start = -80
lw_step = 5
lw_stop = 20
nhist = (lw_stop - lw_start) / lw_step

lw_hist = []
xx_hist = np.arange(lw_start,lw_stop,lw_step) + lw_step / 2.

# Construct model histogram
lw_hists = np.zeros((len(years)*n_ens,nhist))
for ensemble_member in range(1,n_ens+1):
    for (i,year) in enumerate(years):
        all_values_np = values_dics[ensemble_member-1][year]
    
        lw_hist = []
        for start in np.arange(lw_start,lw_stop,lw_step):
            iwhere = np.where(np.logical_and(all_values_np >= start,all_values_np < start+lw_step))
            lw_hist.append(len(iwhere[0]))
    
        total = iwhere[0].shape[0]
        lw_hist = np.array(lw_hist) / float(all_values_np.shape[0])
        lw_hists[i+len(years)*(ensemble_member-1),:] = lw_hist

# Construct obs histogram
SHEBA_hist = []
for start in np.arange(lw_start,lw_stop,lw_step):
    iwhere = np.where(np.logical_and(SHEBA_LWn >= start,\
          SHEBA_LWn < start+lw_step))
    SHEBA_hist.append(len(iwhere[0]))

SHEBA_hist = np.array(SHEBA_hist) / float(SHEBA_LWn.shape[0])

mean_hist = np.mean(lw_hists,axis=0)
std_hist = np.std(lw_hists,axis=0)

xx_plot = np.arange(-.5,13)

index_time = np.array([0,1,2,3,9,10,11])

figure = plt.figure(figsize=(14,6))
ax_cloudprops = figure.add_axes([.05,.15,.36,.8])
ax_lwdown = figure.add_axes([.51,.15,.48,.8])

width = 0.02
xx_hist = (bins[1:] + bins[:-1]) / 2.
hist_aggregate = np.mean(histogram[index_time,:],axis=0)[::-1]
modis_mhist_aggregate = ma.mean(modis_mhistogram[index_time,:],axis=0)[::-1]
h1 = ax_cloudprops.bar(xx_hist-width/2.,hist_aggregate,width,color='r')
h2 = ax_cloudprops.bar(xx_hist+width/2.,modis_mhist_aggregate,width,color='k')

ax_cloudprops.set_ylabel('Frequency',fontproperties = font_use)
ax_cloudprops.set_xlabel('Cloud liquid water fraction',\
    fontproperties = font_use)
ax_cloudprops.legend((h1,h2),('HadGEM2-ES','MODIS'),prop = font_use)

for label in ax_cloudprops.get_xticklabels()+ax_cloudprops.get_yticklabels():
    label.set_fontproperties(font_use)

ax_cloudprops.set_xticks(bins)
ax_cloudprops.set_xticklabels([str(int(bin*100.))+'%' for bin in bins])
ax_cloudprops.set_xlim(0,1)

xx_hist = np.arange(lw_start,lw_stop,lw_step) + lw_step / 2.
width=1.2
h1 = ax_lwdown.bar(xx_hist-width,mean_hist,width,color='r',yerr=std_hist*2)
h2 = ax_lwdown.bar(xx_hist,SHEBA_hist,width,color='k')

ax_cloudprops.set_title('(a)',fontproperties=font_use)
ax_lwdown.set_title('(b)',fontproperties=font_use)

ax_lwdown.set_xlabel('Net LW down',fontproperties=font_use)
ax_lwdown.set_ylabel('Frequency',fontproperties=font_use)
ax_lwdown.legend((h1,h2),('HadGEM2-ES','SHEBA'))

for label in ax_lwdown.get_xticklabels()+ax_lwdown.get_yticklabels():
    label.set_fontproperties(font_use)

pylab.savefig(outfile_eps)
pylab.savefig(outfile_png)

