import iris
import iris.coord_categorisation as icc
import plot_functions as pf
import matplotlib.pyplot as plt
import pylab
import numpy as np
import cartopy.crs as ccrs
import datetime as dt
import field_functions as ff
import regions

sf = ff.sample_field('hadgom')
lat_coord = sf.coord('latitude')
lon_coord = sf.coord('longitude')

outfile = '/home/h01/hadax/graphics/PhD/Papers/Dec2013_HadGEM2_energy_budget/'+\
    'v3.1/Figures/F1_illustrate_isf.eps'
model = 'HadGEM2_ES'
experiment = 'Hist1'
freq = 'monthly'
gridname = 'hadgom'
region_name = 'Arctic_Ocean.0'
version = 'v4_06_09_2018'
obs_scheme = 'std_CERES'

example_vars = ['iimelt','LW_down','Ice_thickness.cat.1','Ice_thickness.cat.3']
example_years = [1980,1980,1980,1980]
example_months = [6,1,11,11]

levels = [[np.arange(-1,1.1,.1),np.arange(-200,201,20),np.arange(-30,31,2)],\
          [np.arange(-50,51,5),np.arange(-1,1.1,.1),np.arange(-20,21,2)],\
          [np.arange(-.7,.71,.1),np.arange(-40,41,5),np.arange(-15,16,1)],\
          [np.arange(-2.,2.1,.1),np.arange(-2.,2.1,.2),np.arange(-1.,1.1,.1)]]
cmap = [plt.get_cmap('RdBu_r')]*3

cl_labels = [['Melting surface fraction anomaly (1)','d($F_{sfc}$)/d(melting surface frac ($Wm^{-2}$)',\
                                                'Induced surface flux anomaly ($Wm^{-2}$)'],\
             ['Downwelling LW anomaly ($Wm^{-2}$)','d($F_{sfc}$)/d(downwelling LW) (1)',\
                                                'Induced surface flux anomaly ($Wm^{-2}$)'],\
             ['Ice thickness anomaly, category 1 (m)','d($F_{sfc}$)/d($h_{1}$) ($Wm^{-3}$)',\
                                                'Induced surface flux anomaly ($Wm^{-2}$)'],\
             ['Ice thickness anomaly, category 3 (m)','d($F_{sfc}$)/d($h_{5}$) ($Wm^{-3}$)',\
                                                'Induced surface flux anomaly ($Wm^{-2}$)']]
 

basedir = '/data/local/hadax/PhD/Attribution/'
datadir = basedir + 'output_' + version + '/' + 'output_3D/' + \
    model + '/' + experiment + '/' + freq + '/' + gridname + '/'

pa_cubelist = iris.cube.CubeList([])
pd_cubelist = iris.cube.CubeList([])
fc_cubelist = iris.cube.CubeList([])
extensions = ['process_anomalies/','partial_derivatives/','']
for [var,year,month] in zip(example_vars,example_years,example_months):
    filenames = [extension + var + '.' + obs_scheme + '.' + str(year) + '.nc' \
                 for extension in extensions]
    files = [datadir + filename for filename in filenames]
    cubes = [iris.load_cube(ffile) for ffile in files]

    cubelist = iris.cube.CubeList([])
    for ccube in cubes:
        icc.add_month(ccube,'time')
        month_name = dt.date(1980,month,1).strftime('%b')
        index = np.where(ccube.coord('month').points == month_name)
        subcube = ccube[index[0][0],:,:]
        regions.reduce_to_region(subcube,region_name,gridname)

        try:
            subcube.add_dim_coord(lat_coord,0)
            subcube.add_dim_coord(lon_coord,1)
        except ValueError:
            pass

        cubelist.append(subcube)

    pa_cubelist.append(cubelist[0])
    pd_cubelist.append(cubelist[1])
    fc_cubelist.append(cubelist[2])

xl = .02
yb = .82
xs = .33
ys = .25
xw = .28
yw = .16

ycl = .02
yw_cl = .01

plot_cl = [pa_cubelist,pd_cubelist,fc_cubelist]
nps = ccrs.NorthPolarStereo()
letters = [['(a)','(b)','(c)'],['(d)','(e)','(f)'],['(g)','(h)','(i)'],\
    ['(j)','(k)','(l)']]

figure = plt.figure(figsize=(10,15))
for xi in range(3):
    for yi in range(4):
        print xi, yi
        axis = figure.add_axes([xl+xs*xi,yb-ys*yi,xw,yw],projection=nps)
        clev = pf.polarplot(plot_cl[xi][yi],figure=figure,axis=axis,\
            colorbar = False, show = False, levels = levels[yi][xi], \
            cmap = cmap[xi], title = letters[yi][xi],rrange=3.e6)
    
        cl_axis = figure.add_axes([xl+xs*xi,yb-ys*yi-ycl,xw,yw_cl])
        plt.colorbar(clev,cax=cl_axis,orientation = 'horizontal')
        cl_axis.text(.5,-3.,cl_labels[yi][xi],ha='center')

pylab.savefig(outfile)
