'''Calculates ratio between estimated and actual surface flux in winter as described in Appendix A'''

import iris
import regions
import numpy as np
import copy
import iris.coord_categorisation as icc
import datetime as dt

model = 'HadGEM2_ES'
experiment = 'Hist1'
startyear = 1980
endyear = 1999
region_name = 'Arctic_Ocean.0'

basedir = '/data/local/hadax/PhD/Attribution/'
datadir = basedir + model + '/' + experiment + '/' + 'monthly/hadgom/'
years = range(startyear,endyear+1)

threshold = 271.15
season_log_varname = 'l_Tsfc_cold.'+str(threshold)

vars_read = ['LW_down','SW_down','iimelt','LW_net','Total_surface_flux','Sensible_heat_flux_over_ice','complex_scale_factor','Ice_thickness',\
    'Snow_volume','TTsfc','B_lw_dep','C_lw_ref','Ice_area',season_log_varname,'SW_net',\
    'LW_net','Sensible_heat_flux_over_ocean','f_atmos_ice','f_atmos_ocean','ice_albedo','Latent_heat_flux',\
    'Sensible_heat_flux']

cubelist_list = {var: iris.cube.CubeList([]) for var in vars_read}
months_examine = [10,11,12,1,2,3,4]

Tfreeze = 273.15
alpha_o = 0.06
Tbot = -1.8
emis_ice = 1.0
sb_const = 5.67e-8

proportion = np.zeros((len(months_examine),len(years)))
for year in years:
    print year
    ffiles = {var: datadir + var + '/' + str(year) + '.nc' for var in vars_read}
    cubes = {var: iris.load_cube(ffiles[var]) for var in vars_read}
    cube_ref = cubes['LW_down']
    cubes_cfg = {}
    for var in vars_read:
        ccube_cfg = copy.deepcopy(cube_ref)
        ccube_cfg.data = cubes[var].data
        cubes_cfg[var] = ccube_cfg

    Tbot_cube = cubes_cfg['TTsfc'] * -1. + Tbot + Tfreeze

    winter_Fsfc_synth = cubes_cfg['Ice_area'] * (cubes_cfg['f_atmos_ice'] + cubes_cfg['B_lw_dep'] * Tbot_cube) * \
        cubes_cfg['complex_scale_factor'] + cubes_cfg['f_atmos_ocean'] * (cubes_cfg['Ice_area'] * -1. + 1.)
    summer_Fsfc_synth = cubes_cfg['LW_down'] + cubes_cfg['Sensible_heat_flux'] + cubes_cfg['Latent_heat_flux'] + \
                          cubes_cfg['SW_down'] * (cubes_cfg['Ice_area']*(cubes_cfg['ice_albedo'] * -1. + 1.) + \
                                                  (cubes_cfg['Ice_area']*-1.+1.)*(1-alpha_o)) - \
                          cubes_cfg['TTsfc']**4. * emis_ice * sb_const

    total_Fsfc_synth = winter_Fsfc_synth * cubes_cfg[season_log_varname] + \
        summer_Fsfc_synth * (cubes_cfg[season_log_varname] * -1. + 1.)

    cubes_cfg['Fsfc_synth'] = total_Fsfc_synth
    
    for (imonth,month) in enumerate(months_examine):
        subcube_real = cubes_cfg['Total_surface_flux'][month-1,:,:]
        subcube_synth = cubes_cfg['Fsfc_synth'][month-1,:,:]
        regions.reduce_to_region(subcube_real,region_name,'hadgom')
        regions.reduce_to_region(subcube_synth,region_name,'hadgom')

        index = np.where(np.logical_and(subcube_real.data < 1.e20,subcube_synth.data < 1.e20))
        array_real = subcube_real.data[index]
        array_synth = subcube_synth.data[index]
        gradline = np.polyfit(array_synth,array_real,1)
        proportion.itemset((imonth,year-startyear),gradline[0])

ffile = '/data/local/hadax/PhD/Attribution/output_v4_06_09_2018/output_1D/HadGEM2_ES/Hist1/monthly/hadgom/LW_down.std_CERES.1999.Arctic_Ocean.0.nc'
ccube = iris.load_cube(ffile)
icc.add_month(ccube,'time')
data = np.zeros((7,20))
for (iyear,year) in enumerate(range(1980,2000)):
    for (imonth,month) in enumerate(months_examine):
        subcube = ccube[iyear*12:(iyear+1)*12]
        month_name = dt.date(1980,month,1).strftime('%b')
        index = np.where(subcube.coord('month').points == month_name)
        datapoint = subcube[index[0]].data
        data.itemset((imonth,iyear),datapoint)
