def write(region_name = 'Arctic_Ocean.1', variable = None):
    import iris
    import glob
    import os
    import numpy as np
    import numpy.ma as ma
    import regions
    import cube_magic as cm
    import datetime as dt
    
    if variable is None:
        print 'Please specify a variable name'
    datadir = '/project/earthobs/COSP/mon/'
    savedir = '/data/cr1/hadax/PhD/timeseries/cl_modis/monthly/'
    fulldir = datadir + variable + '/'
    savefile = savedir + variable + '.' + region_name + '.nc'
    
    startyear = 2002
    endyear = 2011

    ref_date = dt.date(1978,9,1)
    ref_units = ref_date.strftime('Days since %Y-%m-%d')

    datapoints = []
    maskpoints = []
    timepoints = []
    for year in range(startyear,endyear + 1):
        print year
        for month in range(1,13):
            timepoint = dt.date(year,month,1).toordinal() - \
                        ref_date.toordinal()
            timepoints.append(timepoint)
            ffile = fulldir + variable + '_2D.' + str(year) + '.' + \
                       str(month).zfill(2) + '.99.nc'

            if os.path.exists(ffile):
                cubes = iris.load(ffile)
                rcubes = [cube for cube in cubes if cube.shape==(1,180,360)]
                if len(rcubes) != 1:
                    print 'Could not identify the right cube for year '+\
                        str(year)+', month '+str(month)
                    datapoints.append(0.)
                    maskpoints.append(True)
                else:
                    cube = rcubes[0]
        
                    cm.llbounds(cube)
                    aw = iris.analysis.cartography.area_weights(cube)
                    regions.reduce_to_region(cube,region_name,'onedeg')
                    datapoint = cube.collapsed(['latitude','longitude'],\
                                iris.analysis.MEAN,weights = aw).data[0]
    
                    timepoint = dt.date(year,month,1).toordinal() - \
                                ref_date.toordinal()
    
                    datapoints.append(datapoint)
                    maskpoints.append(False)
            else:
                datapoints.append(0.)
                maskpoints.append(True)

    datapoints = np.array(datapoints)
    maskpoints = np.array(maskpoints)
    timepoints = np.array(timepoints)

    mdatapoints = ma.masked_array(datapoints, mask = maskpoints)
    
    return_cube = iris.cube.Cube(mdatapoints)
    time_coord = iris.coords.DimCoord(timepoints, 'time', \
                  units = ref_units)
    return_cube.add_dim_coord(time_coord,0)
    iris.save(return_cube,savefile)

def find_ice_ratio(region_name = 'Arctic_Ocean.1',bins=[0.,.2,.4,.6,.8,1.]):
    import iris
    import glob
    import os
    import numpy as np
    import numpy.ma as ma
    import regions
    import cube_magic as cm
    import datetime as dt
    import copy

    datadir = '/project/earthobs/COSP/mon/'
    savedir = '/data/cr1/hadax/PhD/timeseries/cl_modis/monthly/'
    startyear = 2002
    endyear = 2011

    lwf_dir = datadir + 'clwmodis/'
    iwf_dir = datadir + 'climodis/'
    lwp_dir = datadir + 'lwpmodis/'
    iwp_dir = datadir + 'iwpmodis/'

    histogram = np.zeros((12,len(bins)-1))
    nvals = np.zeros((12,len(bins)-1))

    for month in range(1,13):
        print month
        for year in range(startyear,endyear + 1):
            lwp_file = lwp_dir + 'lwpmodis' + '_2D.' + str(year) + '.' + \
                       str(month).zfill(2) + '.99.nc'
            iwp_file = iwp_dir + 'iwpmodis' + '_2D.' + str(year) + '.' + \
                       str(month).zfill(2) + '.99.nc'
            lwf_file = lwf_dir + 'clwmodis' + '_2D.' + str(year) + '.' + \
                       str(month).zfill(2) + '.99.nc'
            iwf_file = iwf_dir + 'climodis' + '_2D.' + str(year) + '.' + \
                       str(month).zfill(2) + '.99.nc'

            if os.path.exists(lwp_file) and os.path.exists(iwp_file):
                lcubes = iris.cube.CubeList([])
                for ffile in [lwp_file,iwp_file,lwf_file,iwf_file]:
                    cubes = iris.load(ffile)
                    rcubes = [cube for cube in cubes if cube.shape==(1,180,360)]
                    if len(rcubes) != 1:
                        print 'Could not identify the right cube for year '+\
                            str(year)+', month '+str(month)
                    else:
                        cube = rcubes[0]
        
                        cm.llbounds(cube)
                        regions.reduce_to_region(cube,region_name,'onedeg')
                        lcubes.append(cube)

                ratio_cube = lcubes[1]*lcubes[3] / (lcubes[0]*lcubes[2] + lcubes[1]*lcubes[3])

                for nbin in range(len(bins)-1):
                    lower = bins[nbin]
                    upper = bins[nbin+1]
                    logical_array = np.logical_and(ratio_cube.data >= lower,\
                                           ratio_cube.data <  upper).astype('float')
                    logical_cube = iris.cube.Cube(logical_array)
                    logical_cube.add_dim_coord(ratio_cube.coord('time'),0)
                    logical_cube.add_dim_coord(ratio_cube.coord('latitude'),1)
                    logical_cube.add_dim_coord(ratio_cube.coord('longitude'),2)

                    ref_cube = copy.deepcopy(logical_cube)
                    ref_cube.data.data[:] = 1.

                    cm.llbounds(logical_cube)
                    aw = iris.analysis.cartography.area_weights(logical_cube)
                    bin_ratio = logical_cube.collapsed(['latitude','longitude'],\
                        iris.analysis.MEAN, weights = aw).data[0]
                    ref_ratio = ref_cube.collapsed(['latitude','longitude'],\
                        iris.analysis.MEAN, weights = aw).data[0]

                    histogram[month-1,nbin] = histogram[month-1,nbin] + bin_ratio / ref_ratio
                    nvals[month-1,nbin] = nvals[month-1,nbin] + 1.

    histogram = histogram / nvals
    return histogram


def missing_data_mask(month):
    import iris
    datadir = '/project/earthobs/COSP/mon/clwmodis/'
    sample_year = 2005
    ffile = datadir + 'clwmodis_2D.'+str(sample_year) + '.' + \
        str(month).zfill(2) + '.99.nc'

    cubes = iris.load(ffile)
    rcubes = [cube for cube in cubes if cube.shape==(1,180,360)]

    rcube = rcubes[0]
    data_mask = rcube.data.mask

    dmc = iris.cube.Cube(data_mask[0,:,:].astype('int'))
    dmc.add_dim_coord(rcube.coord('latitude'),0)
    dmc.add_dim_coord(rcube.coord('longitude'),1)
    return dmc

def area_weight(month,region_name = None):
    import cube_magic as cm
    import iris
    import copy
    import regions

    mdm = missing_data_mask(month)
    mdm_for_total = copy.deepcopy(mdm)
    mdm_for_total.data = 1 - mdm.data
    regions.reduce_to_region(mdm_for_total,region_name,'onedeg')

    cm.llbounds(mdm_for_total)
    aw = iris.analysis.cartography.area_weights(mdm_for_total)
    total_area = mdm_for_total.collapsed(['latitude','longitude'],\
        iris.analysis.SUM, weights = aw)
    return total_area.data
