def wrap(array):
    import numpy.ma as ma
    if len(array.shape) > 1:
        print 'Array must be 1D'
        return 0
    
    new_array = ma.concatenate((array[-1:],array,array[:1]))
    return new_array


def lonwrap(array):
    import numpy.ma as ma
    if len(array.shape)==1:
        new_array = ma.concatenate((array,array[:1]+360.))
    elif len(array.shape)==2:
        new_array = ma.concatenate((array,array[:,:1]),axis=1)
    else:
        print 'Input array must have 1 or 2 dimensions'
        return None
    
    return new_array


def mask_dodgy(array,threshold = 3., neighbourhood=7):
    import numpy as np
    import numpy.ma as ma

    if len(array.shape) > 1:
        print 'This only works for rank-1 arrays'
        return None

    npt = array.shape[0]
    ma_array = ma.masked_array(array,mask = np.zeros(npt,dtype='bool'))

    for ii in range(npt):
        min_examine = np.max(np.array([0,ii-neighbourhood]))
        max_examine = np.min(np.array([ii+neighbourhood+1,npt]))

        points_examine = np.concatenate((array[min_examine:ii],\
                                         array[ii+1:max_examine]))

        passed = True
        if np.abs((np.mean(points_examine)-array[ii])) > \
            np.std(points_examine) * threshold:
            passed = False

        for jj in range(points_examine.shape[0]):
            llist = list(points_examine)
            llist.pop(llist.index(points_examine[jj]))
            reduced_points = np.array(llist)
            if np.abs((np.mean(reduced_points)-array[ii])) > \
                np.std(reduced_points) * threshold:
                passed = False

        if not passed:
            ma_array.mask[ii] = True

    return ma_array
